/*
 * Decompiled with CFR 0.152.
 */
package arc.audio;

import arc.Core;
import arc.audio.AudioSource;
import arc.audio.Soloud;
import arc.files.Fi;
import arc.util.ArcRuntimeException;
import arc.util.Nullable;
import java.io.File;
import java.io.IOException;

public class Music
extends AudioSource {
    @Nullable
    Fi file;
    int voice = -1;
    boolean looping;
    float volume = 1.0f;
    float pitch = 1.0f;
    float pan = 0.0f;

    public Music(Fi file) throws Exception {
        this.load(file);
    }

    public Music() {
    }

    public void load(Fi file) throws Exception {
        this.file = file;
        ArcRuntimeException last = null;
        for (Fi result : Music.caches(file.nameWithoutExtension() + "__" + file.length() + "." + file.extension())) {
            if (!result.exists() || result.isDirectory() || result.length() != file.length()) {
                file.copyTo(result);
            }
            try {
                this.handle = Soloud.streamLoad(result.file().getCanonicalPath());
                return;
            }
            catch (Exception e) {
                try {
                    this.handle = Soloud.streamLoad(result.file().getAbsolutePath());
                    return;
                }
                catch (Exception exception) {
                    last = new ArcRuntimeException("Error loading music: " + result.file().getCanonicalPath(), e);
                }
            }
        }
        if (last != null) {
            throw last;
        }
    }

    public void play() {
        if (this.handle == 0L || !Core.audio.initialized) {
            return;
        }
        if (Soloud.idValid(this.voice) && Soloud.idGetPause(this.voice)) {
            this.pause(false);
        } else {
            this.voice = Soloud.sourcePlayBus(this.handle, Core.audio.musicBus.handle, this.volume, this.pitch, this.pan, this.looping);
            Soloud.idProtected(this.voice, true);
        }
    }

    public void pause(boolean pause) {
        if (this.handle == 0L || this.voice <= 0) {
            return;
        }
        Soloud.idPause(this.voice, pause);
    }

    public void stop() {
        if (this.handle == 0L || this.voice <= 0) {
            return;
        }
        Soloud.sourceStop(this.handle);
        this.voice = 0;
    }

    public boolean isPlaying() {
        if (this.handle == 0L || this.voice <= 0) {
            return false;
        }
        return Soloud.idValid(this.voice) && !Soloud.idGetPause(this.voice);
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setLooping(boolean isLooping) {
        this.looping = isLooping;
        if (this.handle == 0L || this.voice <= 0) {
            return;
        }
        Soloud.idLooping(this.voice, isLooping);
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        this.volume = volume;
        if (this.handle == 0L || this.voice <= 0) {
            return;
        }
        Soloud.idVolume(this.voice, volume);
    }

    public void set(float pan, float volume) {
        this.volume = volume;
        this.pan = pan;
        if (this.handle == 0L || this.voice <= 0) {
            return;
        }
        Soloud.idVolume(this.voice, volume);
        Soloud.idPan(this.voice, pan);
    }

    public float getPosition() {
        if (this.handle == 0L) {
            return 0.0f;
        }
        return Soloud.idPosition(this.voice);
    }

    public void setPosition(float position) {
        if (this.handle == 0L || this.voice <= 0) {
            return;
        }
        Soloud.idSeek(this.voice, position);
    }

    public String toString() {
        return "SoloudMusic: " + this.file;
    }

    protected static Fi[] caches(String name) throws IOException {
        String dir = System.getProperty("java.io.tmpdir");
        if (Core.app.isAndroid()) {
            return new Fi[]{Core.files.cache(name), Core.settings.getDataDirectory().child("cache").child(name), dir == null ? Core.files.absolute(File.createTempFile(name, "mind").getAbsolutePath()) : Core.files.absolute(dir).child(name)};
        }
        return new Fi[]{Core.settings.getDataDirectory().child("cache").child(name), Core.files.cache(name), dir == null ? Core.files.absolute(File.createTempFile(name, "mind").getAbsolutePath()) : Core.files.absolute(dir).child(name)};
    }
}

