/*
 * Decompiled with CFR 0.152.
 */
package arc.assets;

import arc.assets.AssetLoaderParameters;
import arc.files.Fi;
import arc.func.Cons;
import arc.util.Nullable;

public class AssetDescriptor<T> {
    public final String fileName;
    public final Class<T> type;
    public final AssetLoaderParameters params;
    public Fi file;
    public Cons<T> loaded;
    @Nullable
    public Cons<Throwable> errored;

    public AssetDescriptor(Class<T> assetType) {
        this(assetType.getSimpleName(), assetType, null);
    }

    public AssetDescriptor(String fileName, Class<T> assetType) {
        this(fileName, assetType, null);
    }

    public AssetDescriptor(Fi file, Class<T> assetType) {
        this(file, assetType, null);
    }

    public AssetDescriptor(String fileName, Class<T> assetType, AssetLoaderParameters<T> params) {
        this.loaded = t -> {};
        this.errored = null;
        this.fileName = fileName.replaceAll("\\\\", "/");
        this.type = assetType;
        this.params = params;
    }

    public AssetDescriptor(Fi file, Class<T> assetType, AssetLoaderParameters<T> params) {
        this.loaded = t -> {};
        this.errored = null;
        this.fileName = file.path().replaceAll("\\\\", "/");
        this.file = file;
        this.type = assetType;
        this.params = params;
    }

    public String toString() {
        return this.fileName + ", " + this.type.getName();
    }
}

