/*
 * Decompiled with CFR 0.152.
 */
package arc;

import arc.Core;
import arc.func.Prov;
import arc.input.InputDevice;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;

public class KeyBinds {
    private Section defaultSection;
    private ObjectMap<KeyBind, ObjectMap<InputDevice.DeviceType, Axis>> defaultCache = new ObjectMap();
    private KeyBind[] definitions;
    private Section[] sections;

    public void setDefaults(KeyBind[] defs, Section ... sectionArr) {
        this.defaultSection = new Section("default");
        this.definitions = defs;
        this.sections = new Section[sectionArr.length + 1];
        this.sections[0] = this.defaultSection;
        System.arraycopy(sectionArr, 0, this.sections, 1, sectionArr.length);
        for (KeyBind def : defs) {
            this.defaultCache.put(def, new ObjectMap());
            for (InputDevice.DeviceType type : InputDevice.DeviceType.values()) {
                this.defaultCache.get(def).put(type, def.defaultValue(type) instanceof Axis ? (Axis)def.defaultValue(type) : new Axis((KeyCode)def.defaultValue(type)));
            }
        }
    }

    void save() {
        if (this.definitions == null) {
            return;
        }
        for (Section sec : this.sections) {
            for (InputDevice.DeviceType type : sec.binds.keys()) {
                for (ObjectMap.Entry entry : sec.binds.get(type).entries()) {
                    String rname = "keybind-" + sec.name + "-" + type.name() + "-" + ((KeyBind)entry.key).name();
                    this.save((Axis)entry.value, rname);
                }
            }
            Core.settings.put(sec.name + "-last-device-type", Core.input.getDevices().indexOf(sec.device, true));
        }
    }

    void load() {
        if (this.definitions == null) {
            return;
        }
        for (Section sec : this.sections) {
            for (InputDevice.DeviceType type : InputDevice.DeviceType.values()) {
                for (KeyBind def : this.definitions) {
                    String rname = "keybind-" + sec.name + "-" + type.name() + "-" + def.name();
                    Axis loaded = this.load(rname);
                    if (loaded == null) continue;
                    ((OrderedMap)((Object)sec.binds.get(type, (OrderedMap<KeyBind, Axis>)((Object)((Prov<OrderedMap>)OrderedMap::new))))).put(def, loaded);
                }
            }
            sec.device = Core.input.getDevices().get(Mathf.clamp(Core.settings.getInt(sec.name + "-last-device-type", 0), 0, Core.input.getDevices().size - 1));
        }
    }

    public void resetToDefaults() {
        for (Section sec : this.sections) {
            for (InputDevice.DeviceType type : sec.binds.keys()) {
                for (KeyBind def : this.definitions) {
                    String rname = "keybind-" + sec.name + "-" + type.name() + "-" + def.name();
                    Core.settings.remove(rname + "-single");
                    Core.settings.remove(rname + "-key");
                    Core.settings.remove(rname + "-min");
                    Core.settings.remove(rname + "-max");
                }
            }
        }
        for (Section sec : this.sections) {
            sec.binds.clear();
        }
    }

    public void resetToDefault(Section section, KeyBind bind) {
        String rname = "keybind-" + section.name + "-" + section.device.type().name() + "-" + bind.name();
        Core.settings.remove(rname + "-single");
        Core.settings.remove(rname + "-key");
        Core.settings.remove(rname + "-min");
        Core.settings.remove(rname + "-max");
        section.binds.each((device, bindings) -> bindings.remove(bind));
    }

    private void save(Axis axis, String name) {
        Core.settings.put(name + "-single", axis.key != null);
        if (axis.key != null) {
            Core.settings.put(name + "-key", axis.key.ordinal());
        } else {
            Core.settings.put(name + "-min", axis.min.ordinal());
            Core.settings.put(name + "-max", axis.max.ordinal());
        }
    }

    private Axis load(String name) {
        if (Core.settings.getBool(name + "-single", true)) {
            KeyCode key = KeyCode.byOrdinal(Core.settings.getInt(name + "-key", KeyCode.unset.ordinal()));
            return key == KeyCode.unset ? null : new Axis(key);
        }
        KeyCode min = KeyCode.byOrdinal(Core.settings.getInt(name + "-min", KeyCode.unset.ordinal()));
        KeyCode max = KeyCode.byOrdinal(Core.settings.getInt(name + "-max", KeyCode.unset.ordinal()));
        return min == KeyCode.unset || max == KeyCode.unset ? null : new Axis(min, max);
    }

    public Section[] getSections() {
        return this.sections;
    }

    public KeyBind[] getKeybinds() {
        return this.definitions;
    }

    public Axis get(KeyBind name) {
        return this.get(this.defaultSection, name);
    }

    public Axis get(Section section, KeyBind def) {
        if (this.definitions == null) {
            throw new IllegalArgumentException("No keybinds defined! Did you forget to call setDefaults(...)?");
        }
        return this.get(section, section.device.type(), def);
    }

    public Axis get(Section section, InputDevice.DeviceType type, KeyBind def) {
        if (section.binds.containsKey(type) && section.binds.get(type).containsKey(def)) {
            return (Axis)section.binds.get(type).get(def);
        }
        return this.defaultCache.get(def).get(type);
    }

    public static class Section {
        public final String name;
        public ObjectMap<InputDevice.DeviceType, OrderedMap<KeyBind, Axis>> binds = new ObjectMap();
        public InputDevice device = Core.input.getKeyboard();

        Section(String name) {
            this.name = name;
        }
    }

    public static interface KeyBind {
        public String name();

        public KeybindValue defaultValue(InputDevice.DeviceType var1);

        default public String category() {
            return null;
        }
    }

    public static interface KeybindValue {
    }

    public static class Axis
    implements KeybindValue {
        public KeyCode min;
        public KeyCode max;
        public KeyCode key;

        public Axis(KeyCode key) {
            this.key = key;
            this.max = null;
            this.min = null;
        }

        public Axis(KeyCode min, KeyCode max) {
            this.min = min;
            this.max = max;
            this.key = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Axis axis = (Axis)o;
            if (this.min != axis.min) {
                return false;
            }
            if (this.max != axis.max) {
                return false;
            }
            return this.key == axis.key;
        }

        public String toString() {
            return "Axis{min=" + this.min + ", max=" + this.max + ", key=" + this.key + '}';
        }
    }
}

