/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.hateoas.server.core.MappingDiscoverer;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

public class CachingMappingDiscoverer
implements MappingDiscoverer {
    private static final Map<String, String> MAPPINGS = new ConcurrentReferenceHashMap();
    private static final Map<String, Collection<HttpMethod>> METHODS = new ConcurrentReferenceHashMap();
    private static final Map<String, String[]> PARAMS = new ConcurrentReferenceHashMap();
    private static final Map<String, List<MediaType>> CONSUMES = new ConcurrentReferenceHashMap();
    private final MappingDiscoverer delegate;

    private CachingMappingDiscoverer(MappingDiscoverer delegate) {
        this.delegate = delegate;
    }

    public static CachingMappingDiscoverer of(MappingDiscoverer delegate) {
        return new CachingMappingDiscoverer(delegate);
    }

    @Override
    @Nullable
    public String getMapping(Class<?> type) {
        String key = CachingMappingDiscoverer.key(type, null);
        return MAPPINGS.computeIfAbsent(key, __ -> this.delegate.getMapping(type));
    }

    @Override
    @Nullable
    public String getMapping(Method method) {
        return MAPPINGS.computeIfAbsent(CachingMappingDiscoverer.key(method), __ -> this.delegate.getMapping(method));
    }

    @Override
    @Nullable
    public String getMapping(Class<?> type, Method method) {
        String key = CachingMappingDiscoverer.key(type, method);
        return MAPPINGS.computeIfAbsent(key, __ -> this.delegate.getMapping(type, method));
    }

    @Override
    public Collection<HttpMethod> getRequestMethod(Class<?> type, Method method) {
        return METHODS.computeIfAbsent(CachingMappingDiscoverer.key(type, method), __ -> this.delegate.getRequestMethod(type, method));
    }

    @Override
    public List<MediaType> getConsumes(Method method) {
        return CONSUMES.computeIfAbsent(CachingMappingDiscoverer.key(method), __ -> this.delegate.getConsumes(method));
    }

    @Override
    public String[] getParams(Method method) {
        return PARAMS.computeIfAbsent(CachingMappingDiscoverer.key(method), __ -> this.delegate.getParams(method));
    }

    private static String key(Method method) {
        return CachingMappingDiscoverer.key(method.getDeclaringClass(), method);
    }

    private static String key(Class<?> type, @Nullable Method method) {
        StringBuilder builder = new StringBuilder(type.getName());
        if (method == null) {
            return builder.toString();
        }
        builder.append(method.getName());
        builder.append(StringUtils.arrayToCommaDelimitedString((Object[])method.getParameterTypes()));
        return builder.toString();
    }
}

