/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.gradle.remote;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.asciidoctor.Options;
import org.asciidoctor.ast.Cursor;
import org.asciidoctor.gradle.internal.ExecutorConfiguration;
import org.asciidoctor.gradle.internal.ExecutorConfigurationContainer;
import org.asciidoctor.gradle.internal.ExecutorLogLevel;
import org.asciidoctor.gradle.remote.AsciidoctorRemoteExecutionException;
import org.asciidoctor.gradle.remote.LogSeverityMapper;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public abstract class ExecutorBase
implements GroovyObject {
    private static final String ATTR_PROJECT_DIR = "gradle-projectdir";
    private static final String ATTR_ROOT_DIR = "gradle-rootdir";
    private static final String ATTR_REL_SRC_DIR = "gradle-relative-srcdir";
    private final List<String> warningMessages;
    private final List<Pattern> messagePatterns;
    protected int maxSeverityLevel;
    protected int failureLevel;
    protected final List<ExecutorConfiguration> runConfigurations;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    protected ExecutorBase(ExecutorConfigurationContainer execConfig) {
        MetaClass metaClass;
        int n;
        int n2;
        List list;
        List list2;
        this.warningMessages = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.messagePatterns = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.maxSeverityLevel = n2 = 0;
        this.failureLevel = n = 4;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        List<ExecutorConfiguration> list3 = execConfig.getConfigurations();
        this.runConfigurations = list3;
    }

    protected Map<String, Object> normalisedOptionsFor(File file, ExecutorConfiguration runConfiguration) {
        Reference file2 = new Reference((Object)file);
        Reference mergedOptions = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class)));
        public final class _normalisedOptionsFor_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference file;
            private /* synthetic */ Reference mergedOptions;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _normalisedOptionsFor_closure1(Object _outerInstance, Object _thisObject, Reference file, Reference mergedOptions) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.file = reference2 = file;
                this.mergedOptions = reference = mergedOptions;
            }

            public Object doCall(Object it) {
                String srcRelative = ShortTypeHandling.castToString((Object)InvokerHelper.invokeMethodSafe((Object)((ExecutorBase)this.getThisObject()), (String)"getRelativePath", (Object)new Object[]{((File)this.file.get()).getParentFile(), ((ExecutorConfiguration)this.getDelegate()).getSourceDir()}));
                ((LinkedHashMap)this.mergedOptions.get()).putAll(((ExecutorConfiguration)this.getDelegate()).getOptions());
                ((LinkedHashMap)this.mergedOptions.get()).putAll(ScriptBytecodeAdapter.createMap((Object[])new Object[]{Options.BACKEND, ((ExecutorConfiguration)this.getDelegate()).getBackendName(), Options.IN_PLACE, false, Options.SAFE, ((ExecutorConfiguration)this.getDelegate()).getSafeModeLevel(), Options.TO_DIR, (srcRelative.isEmpty() ? ((ExecutorConfiguration)this.getDelegate()).getOutputDir() : new File(((ExecutorConfiguration)this.getDelegate()).getOutputDir(), srcRelative)).getAbsolutePath(), Options.MKDIRS, true}));
                File file = ((ExecutorConfiguration)this.getDelegate()).getBaseDir();
                String string = (DefaultTypeTransformation.booleanUnbox((Object)file) ? file : ((File)this.file.get()).getParentFile()).getAbsolutePath();
                DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.mergedOptions.get(), Map.class)), (Object)Options.BASEDIR, (Object)string);
                if (((LinkedHashMap)this.mergedOptions.get()).containsKey(Options.TO_FILE)) {
                    Object toFileValue = DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.mergedOptions.get(), Map.class)), (Object)Options.TO_FILE);
                    Object toDirValue = ((LinkedHashMap)this.mergedOptions.get()).remove(Options.TO_DIR);
                    File toFile = toFileValue instanceof File ? (File)ScriptBytecodeAdapter.castToType((Object)toFileValue, File.class) : new File(DefaultGroovyMethods.toString((Object)toFileValue));
                    File toDir = toDirValue instanceof File ? (File)ScriptBytecodeAdapter.castToType(toDirValue, File.class) : new File(DefaultGroovyMethods.toString(toDirValue));
                    String string2 = new File(toDir, toFile.getName()).getAbsolutePath();
                    DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.mergedOptions.get(), Map.class)), (Object)Options.TO_FILE, (Object)string2);
                }
                LinkedHashMap newAttrs = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                newAttrs.putAll(((ExecutorConfiguration)this.getDelegate()).getAttributes());
                String string3 = ((ExecutorConfiguration)this.getDelegate()).getProjectDir().getAbsolutePath();
                DefaultGroovyMethods.putAt((Map)newAttrs, (Object)ATTR_PROJECT_DIR, (Object)string3);
                String string4 = ((ExecutorConfiguration)this.getDelegate()).getRootDir().getAbsolutePath();
                DefaultGroovyMethods.putAt((Map)newAttrs, (Object)ATTR_ROOT_DIR, (Object)string4);
                Object object = InvokerHelper.invokeMethodSafe((Object)((ExecutorBase)this.getThisObject()), (String)"getRelativePath", (Object)new Object[]{((ExecutorConfiguration)this.getDelegate()).getSourceDir(), ((File)this.file.get()).getParentFile()});
                String string5 = ShortTypeHandling.castToString((Object)object);
                String string6 = DefaultTypeTransformation.booleanUnbox((Object)object) ? string5 : ".";
                DefaultGroovyMethods.putAt((Map)newAttrs, (Object)ATTR_REL_SRC_DIR, (Object)string6);
                if (((ExecutorConfiguration)this.getDelegate()).getLegacyAttributes()) {
                    Object object2 = DefaultGroovyMethods.getAt((Map)newAttrs, (Object)ATTR_PROJECT_DIR);
                    DefaultGroovyMethods.putAt((Map)newAttrs, (Object)"projectdir", (Object)object2);
                    Object object3 = DefaultGroovyMethods.getAt((Map)newAttrs, (Object)ATTR_ROOT_DIR);
                    DefaultGroovyMethods.putAt((Map)newAttrs, (Object)"rootdir", (Object)object3);
                }
                LinkedHashMap linkedHashMap = newAttrs;
                DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.mergedOptions.get(), Map.class)), (Object)Options.ATTRIBUTES, (Object)linkedHashMap);
                return linkedHashMap;
            }

            public File getFile() {
                return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
            }

            public Map getMergedOptions() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.mergedOptions.get(), Map.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _normalisedOptionsFor_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.with((Object)runConfiguration, (Closure)new _normalisedOptionsFor_closure1(this, this, file2, mergedOptions));
        return (LinkedHashMap)mergedOptions.get();
    }

    protected String getRelativePath(File target, File base) throws IOException {
        return base.toPath().relativize(target.toPath()).toFile().toString();
    }

    protected List<Object> rehydrateExtensions(Object registry, List<Object> exts) {
        List availableExtensions = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Object ext2 = null;
        for (Object ext2 : exts) {
            Object object = ext2;
            if (ScriptBytecodeAdapter.isCase((Object)object, Closure.class)) {
                int n;
                Closure rehydrated = ((Closure)ScriptBytecodeAdapter.castToType((Object)ext2, Closure.class)).rehydrate(registry, null, null);
                rehydrated.setResolveStrategy(n);
                availableExtensions.add(rehydrated);
                continue;
            }
            availableExtensions.add(ext2);
        }
        return availableExtensions;
    }

    protected LogHandler getLogHandler(ExecutorLogLevel required) {
        Reference requiredLevel = new Reference((Object)required.getLevel());
        return new LogHandler(this, requiredLevel){
            public /* synthetic */ Reference requiredLevel;
            public /* synthetic */ ExecutorBase this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                ExecutorBase executorBase;
                this.this$0 = executorBase = p0;
                this.requiredLevel = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public void log(LogRecord logRecord) {
                ExecutorLogLevel logLevel = LogSeverityMapper.translateAsciidoctorLogLevel(logRecord.getSeverity());
                if (logLevel.getLevel() > DefaultTypeTransformation.intUnbox((Object)this.getProperty("maxSeverityLevel"))) {
                    int n = logLevel.getLevel();
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n, 1.class, (GroovyObject)this, (String)"maxSeverityLevel");
                }
                if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)logLevel.getLevel(), (Object)this.requiredLevel.get())) {
                    String msg = logRecord.getMessage();
                    Cursor cursor = logRecord.getCursor();
                    if (DefaultTypeTransformation.booleanUnbox((Object)cursor)) {
                        String string = cursor.getPath();
                        String cPath = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "";
                        String string2 = cursor.getDir();
                        String cDir = DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : "";
                        String string3 = cursor.getFile();
                        String cFile = DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : "";
                        String cLine = cursor.getLineNumber() >= 0 ? Integer.valueOf(cursor.getLineNumber()).toString() : "";
                        GStringImpl gStringImpl = new GStringImpl(new Object[]{msg, cPath, cDir, cFile, cLine}, new String[]{"", " :: ", " :: ", "/", ":", ""});
                        msg = ShortTypeHandling.castToString((Object)gStringImpl);
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)logRecord.getSourceFileName())) {
                        String subMsg = DefaultTypeTransformation.booleanUnbox((Object)logRecord.getSourceMethodName()) ? StringGroovyMethods.plus((String)":", (CharSequence)logRecord.getSourceMethodName()) : "";
                        GStringImpl gStringImpl = new GStringImpl(new Object[]{msg, logRecord.getSourceFileName(), subMsg}, new String[]{"", " (", "", ")"});
                        msg = ShortTypeHandling.castToString((Object)gStringImpl);
                    }
                    this.this$0.logMessage(logLevel, msg);
                }
                this.this$0.addMatchingMessage(logRecord.getMessage());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ExecutorBase.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$1(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ExecutorBase.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, ExecutorBase.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        };
    }

    protected abstract void logMessage(ExecutorLogLevel var1, String var2);

    protected void addMatchingMessage(String msg) {
        Reference msg2 = new Reference((Object)msg);
        public final class _addMatchingMessage_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference msg;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addMatchingMessage_closure2(Object _outerInstance, Object _thisObject, Reference msg) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.msg = reference = msg;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.findRegex((Object)this.msg.get(), (Object)it);
            }

            public String getMsg() {
                return ShortTypeHandling.castToString((Object)this.msg.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addMatchingMessage_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        if (!this.messagePatterns.isEmpty() && DefaultGroovyMethods.any(this.messagePatterns, (Closure)new _addMatchingMessage_closure2(this, this, msg2))) {
            this.warningMessages.add((String)msg2.get());
        }
    }

    protected List<String> getWarningMessages() {
        return this.warningMessages;
    }

    protected void resetMessagePatternsTo(List<Pattern> patterns) {
        this.messagePatterns.clear();
        this.messagePatterns.addAll(patterns);
    }

    protected void failOnWarnings() {
        if (!this.warningMessages.isEmpty()) {
            String msg = StringGroovyMethods.plus((String)"ERROR: The following messages from AsciidoctorJ are treated as errors:\n", (CharSequence)DefaultGroovyMethods.join(this.warningMessages, (String)"\n- "));
            throw (Throwable)new AsciidoctorRemoteExecutionException(msg);
        }
    }

    protected void failOnFailureLevelReachedOrExceeded() {
        if (this.maxSeverityLevel >= this.failureLevel) {
            Severity maxSeverity = LogSeverityMapper.getSeverityOf(this.maxSeverityLevel);
            Severity failureSeverity = LogSeverityMapper.getSeverityOf(this.failureLevel);
            throw (Throwable)new AsciidoctorRemoteExecutionException(StringGroovyMethods.plus((String)"ERROR: Failure level reached or exceeded: ", (CharSequence)new GStringImpl(new Object[]{maxSeverity, failureSeverity}, new String[]{"", " >= ", ""})));
        }
    }

    protected int findHighestFailureLevel(Iterable<Integer> levels) {
        return DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.min(levels), Integer.TYPE));
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ExecutorBase.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ExecutorBase.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ExecutorBase.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ExecutorBase.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

