/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.write.events;

import com.influxdb.client.write.events.AbstractWriteEvent;
import com.influxdb.utils.Arguments;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public final class WriteRetriableErrorEvent
extends AbstractWriteEvent {
    private static final Logger LOG = Logger.getLogger(WriteRetriableErrorEvent.class.getName());
    private final Throwable throwable;
    private final Long retryInterval;

    public WriteRetriableErrorEvent(@Nonnull Throwable throwable, @Nonnull Long retryInterval) {
        Arguments.checkNotNull((Object)throwable, (String)"Throwable");
        Arguments.checkNotNull((Object)retryInterval, (String)"retryInterval");
        this.throwable = throwable;
        this.retryInterval = retryInterval;
    }

    @Nonnull
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Nonnull
    public Long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public void logEvent() {
        String msg = "The retriable error occurred during writing of data. Reason: ''{0}''. Retry in: {1}s.";
        LOG.log(Level.WARNING, msg, new Object[]{this.throwable.getMessage(), (double)this.retryInterval.longValue() / 1000.0});
    }
}

