/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.run;

import java.io.File;
import java.io.Serializable;
import java.util.Set;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Application should always run")
public abstract class BootRun
extends JavaExec {
    public BootRun() {
        this.getOptimizedLaunch().convention((Object)true);
    }

    @Input
    public abstract Property<Boolean> getOptimizedLaunch();

    public void sourceResources(SourceSet sourceSet) {
        File resourcesDir = sourceSet.getOutput().getResourcesDir();
        Set srcDirs = sourceSet.getResources().getSrcDirs();
        this.setClasspath(this.getProject().files(new Object[]{srcDirs, this.getClasspath()}).filter((Spec & Serializable)file -> !file.equals(resourcesDir)));
    }

    public void exec() {
        if (((Boolean)this.getOptimizedLaunch().get()).booleanValue()) {
            this.setJvmArgs(this.getJvmArgs());
            this.jvmArgs(new Object[]{"-XX:TieredStopAtLevel=1"});
        }
        if (System.console() != null) {
            this.getEnvironment().put("spring.output.ansi.console-available", true);
        }
        super.exec();
    }
}

