/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.aot;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import org.springframework.boot.gradle.tasks.aot.AbstractAot;

@CacheableTask
public class ProcessTestAot
extends AbstractAot {
    private FileCollection classpathRoots;

    public ProcessTestAot() {
        this.getMainClass().set((Object)"org.springframework.boot.test.context.SpringBootTestAotProcessor");
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public final FileCollection getClasspathRoots() {
        return this.classpathRoots;
    }

    public void setClasspathRoots(FileCollection classpathRoots) {
        this.classpathRoots = classpathRoots;
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    final FileTree getInputClasses() {
        return this.classpathRoots.getAsFileTree();
    }

    @TaskAction
    public void exec() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getClasspathRoots().getFiles().stream().filter((Predicate<File> & Serializable)file -> FileInterceptorsDeclaration.intercept_exists((File)file, (String)"org.springframework.boot.gradle.tasks.aot.ProcessTestAot")).map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
        args.addAll(this.processorArgs());
        this.setArgs(args);
        super.exec();
    }
}

