/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.springframework.boot.gradle.dsl.SpringBootExtension;
import org.springframework.boot.gradle.plugin.JarTypeFileSpec;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.ResolveMainClassName;
import org.springframework.boot.gradle.plugin.SinglePublishedArtifact;
import org.springframework.boot.gradle.tasks.bundling.BootBuildImage;
import org.springframework.boot.gradle.tasks.bundling.BootJar;
import org.springframework.boot.gradle.tasks.run.BootRun;
import org.springframework.util.StringUtils;

final class JavaPluginAction
implements PluginApplicationAction {
    private static final String PARAMETERS_COMPILER_ARG = "-parameters";
    private final SinglePublishedArtifact singlePublishedArtifact;

    JavaPluginAction(SinglePublishedArtifact singlePublishedArtifact) {
        this.singlePublishedArtifact = singlePublishedArtifact;
    }

    @Override
    public Class<? extends Plugin<? extends Project>> getPluginClass() {
        return JavaPlugin.class;
    }

    public void execute(Project project) {
        this.classifyJarTask(project);
        this.configureBuildTask(project);
        this.configureProductionRuntimeClasspathConfiguration(project);
        this.configureDevelopmentOnlyConfiguration(project);
        this.configureTestAndDevelopmentOnlyConfiguration(project);
        TaskProvider<ResolveMainClassName> resolveMainClassName = this.configureResolveMainClassNameTask(project);
        TaskProvider<BootJar> bootJar = this.configureBootJarTask(project, resolveMainClassName);
        this.configureBootBuildImageTask(project, bootJar);
        this.configureArtifactPublication(bootJar);
        this.configureBootRunTask(project, resolveMainClassName);
        TaskProvider<ResolveMainClassName> resolveMainTestClassName = this.configureResolveMainTestClassNameTask(project);
        this.configureBootTestRunTask(project, resolveMainTestClassName);
        project.afterEvaluate(this::configureUtf8Encoding);
        this.configureParametersCompilerArg(project);
        this.configureAdditionalMetadataLocations(project);
    }

    private void classifyJarTask(Project project) {
        project.getTasks().named("jar", Jar.class).configure((Action & Serializable)task -> task.getArchiveClassifier().convention((Object)"plain"));
    }

    private void configureBuildTask(Project project) {
        project.getTasks().named("assemble").configure((Action & Serializable)task -> task.dependsOn(new Object[]{this.singlePublishedArtifact}));
    }

    private TaskProvider<ResolveMainClassName> configureResolveMainClassNameTask(Project project) {
        return project.getTasks().register("resolveMainClassName", ResolveMainClassName.class, (Action & Serializable)resolveMainClassName -> {
            ExtensionContainer extensions = project.getExtensions();
            resolveMainClassName.setDescription("Resolves the name of the application's main class.");
            resolveMainClassName.setGroup("build");
            Callable<FileCollection> & Serializable classpath = (Callable<FileCollection> & Serializable)() -> ((SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")).getOutput();
            resolveMainClassName.setClasspath(classpath);
            resolveMainClassName.getConfiguredMainClassName().convention(project.provider((Callable<String> & Serializable)() -> {
                String javaApplicationMainClass = JavaPluginAction.getJavaApplicationMainClass(extensions);
                if (javaApplicationMainClass != null) {
                    return javaApplicationMainClass;
                }
                SpringBootExtension springBootExtension = (SpringBootExtension)project.getExtensions().findByType(SpringBootExtension.class);
                return (String)springBootExtension.getMainClass().getOrNull();
            }));
            resolveMainClassName.getOutputFile().set(project.getLayout().getBuildDirectory().file("resolvedMainClassName"));
        });
    }

    private TaskProvider<ResolveMainClassName> configureResolveMainTestClassNameTask(Project project) {
        return project.getTasks().register("resolveTestMainClassName", ResolveMainClassName.class, (Action & Serializable)resolveMainClassName -> {
            resolveMainClassName.setDescription("Resolves the name of the application's test main class.");
            resolveMainClassName.setGroup("build");
            Callable<FileCollection> & Serializable classpath = (Callable<FileCollection> & Serializable)() -> {
                SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
                return project.files(new Object[]{((SourceSet)sourceSets.getByName("test")).getOutput(), ((SourceSet)sourceSets.getByName("main")).getOutput()});
            };
            resolveMainClassName.setClasspath(classpath);
            resolveMainClassName.getOutputFile().set(project.getLayout().getBuildDirectory().file("resolvedMainTestClassName"));
        });
    }

    private static String getJavaApplicationMainClass(ExtensionContainer extensions) {
        JavaApplication javaApplication = (JavaApplication)extensions.findByType(JavaApplication.class);
        if (javaApplication == null) {
            return null;
        }
        return (String)javaApplication.getMainClass().getOrNull();
    }

    private TaskProvider<BootJar> configureBootJarTask(Project project, TaskProvider<ResolveMainClassName> resolveMainClassName) {
        SourceSet mainSourceSet = (SourceSet)this.javaPluginExtension(project).getSourceSets().getByName("main");
        Configuration developmentOnly = project.getConfigurations().getByName("developmentOnly");
        Configuration testAndDevelopmentOnly = project.getConfigurations().getByName("testAndDevelopmentOnly");
        Configuration productionRuntimeClasspath = project.getConfigurations().getByName("productionRuntimeClasspath");
        Configuration runtimeClasspath = project.getConfigurations().getByName(mainSourceSet.getRuntimeClasspathConfigurationName());
        Callable<FileCollection> & Serializable classpath = (Callable<FileCollection> & Serializable)() -> mainSourceSet.getRuntimeClasspath().minus(developmentOnly.minus((FileCollection)productionRuntimeClasspath)).minus(testAndDevelopmentOnly.minus((FileCollection)productionRuntimeClasspath)).filter((Spec)new JarTypeFileSpec());
        return project.getTasks().register("bootJar", BootJar.class, (Action & Serializable)bootJar -> {
            bootJar.setDescription("Assembles an executable jar archive containing the main classes and their dependencies.");
            bootJar.setGroup("build");
            bootJar.classpath(classpath);
            Provider manifestStartClass = project.provider((Callable<String> & Serializable)() -> (String)bootJar.getManifest().getAttributes().get((Object)"Start-Class"));
            bootJar.getMainClass().convention(resolveMainClassName.flatMap((Transformer & Serializable)resolver -> manifestStartClass.isPresent() ? manifestStartClass : resolver.readMainClassName()));
            bootJar.getTargetJavaVersion().set(project.provider((Callable<JavaVersion> & Serializable)() -> this.javaPluginExtension(project).getTargetCompatibility()));
            bootJar.resolvedArtifacts((Provider<Set<ResolvedArtifactResult>>)runtimeClasspath.getIncoming().getArtifacts().getResolvedArtifacts());
        });
    }

    private void configureBootBuildImageTask(Project project, TaskProvider<BootJar> bootJar) {
        project.getTasks().register("bootBuildImage", BootBuildImage.class, (Action & Serializable)buildImage -> {
            buildImage.setDescription("Builds an OCI image of the application using the output of the bootJar task");
            buildImage.setGroup("build");
            buildImage.getArchiveFile().set(((BootJar)bootJar.get()).getArchiveFile());
        });
    }

    private void configureArtifactPublication(TaskProvider<BootJar> bootJar) {
        this.singlePublishedArtifact.addJarCandidate(bootJar);
    }

    private void configureBootRunTask(Project project, TaskProvider<ResolveMainClassName> resolveMainClassName) {
        Callable<FileCollection> & Serializable classpath = (Callable<FileCollection> & Serializable)() -> ((SourceSet)this.javaPluginExtension(project).getSourceSets().findByName("main")).getRuntimeClasspath().filter((Spec)new JarTypeFileSpec());
        project.getTasks().register("bootRun", BootRun.class, (Action & Serializable)run -> {
            run.setDescription("Runs this project as a Spring Boot application.");
            run.setGroup("application");
            run.classpath(new Object[]{classpath});
            run.getMainClass().convention(resolveMainClassName.flatMap(ResolveMainClassName::readMainClassName));
            this.configureToolchainConvention(project, (BootRun)((Object)run));
        });
    }

    private void configureBootTestRunTask(Project project, TaskProvider<ResolveMainClassName> resolveMainClassName) {
        Callable<FileCollection> & Serializable classpath = (Callable<FileCollection> & Serializable)() -> ((SourceSet)this.javaPluginExtension(project).getSourceSets().findByName("test")).getRuntimeClasspath().filter((Spec)new JarTypeFileSpec());
        project.getTasks().register("bootTestRun", BootRun.class, (Action & Serializable)run -> {
            run.setDescription("Runs this project as a Spring Boot application using the test runtime classpath.");
            run.setGroup("application");
            run.classpath(new Object[]{classpath});
            run.getMainClass().convention(resolveMainClassName.flatMap(ResolveMainClassName::readMainClassName));
            this.configureToolchainConvention(project, (BootRun)((Object)run));
        });
    }

    private void configureToolchainConvention(Project project, BootRun run) {
        JavaToolchainSpec toolchain = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getToolchain();
        JavaToolchainService toolchainService = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        run.getJavaLauncher().convention(toolchainService.launcherFor(toolchain));
    }

    private JavaPluginExtension javaPluginExtension(Project project) {
        return (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
    }

    private void configureUtf8Encoding(Project evaluatedProject) {
        evaluatedProject.getTasks().withType(JavaCompile.class).configureEach(this::configureUtf8Encoding);
    }

    private void configureUtf8Encoding(JavaCompile compile) {
        if (compile.getOptions().getEncoding() == null) {
            compile.getOptions().setEncoding("UTF-8");
        }
    }

    private void configureParametersCompilerArg(Project project) {
        project.getTasks().withType(JavaCompile.class).configureEach((Action & Serializable)compile -> {
            List compilerArgs = compile.getOptions().getCompilerArgs();
            if (!compilerArgs.contains(PARAMETERS_COMPILER_ARG)) {
                compilerArgs.add(PARAMETERS_COMPILER_ARG);
            }
        });
    }

    private void configureAdditionalMetadataLocations(Project project) {
        project.afterEvaluate((Action & Serializable)evaluated -> evaluated.getTasks().withType(JavaCompile.class).configureEach(this::configureAdditionalMetadataLocations));
    }

    private void configureAdditionalMetadataLocations(JavaCompile compile) {
        SourceSetContainer sourceSets = ((JavaPluginExtension)compile.getProject().getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
        sourceSets.stream().filter((Predicate<SourceSet> & Serializable)candidate -> candidate.getCompileJavaTaskName().equals(compile.getName())).map((Function<SourceSet, Set> & Serializable)match -> match.getResources().getSrcDirs()).findFirst().ifPresent((Consumer<Set> & Serializable)locations -> compile.doFirst((Action)new AdditionalMetadataLocationsConfigurer((Set<File>)locations)));
    }

    private void configureProductionRuntimeClasspathConfiguration(Project project) {
        Configuration productionRuntimeClasspath = (Configuration)project.getConfigurations().create("productionRuntimeClasspath");
        productionRuntimeClasspath.setVisible(false);
        Configuration runtimeClasspath = project.getConfigurations().getByName("runtimeClasspath");
        productionRuntimeClasspath.attributes((Action & Serializable)attributes -> {
            ProviderFactory providers = project.getProviders();
            AttributeContainer sourceAttributes = runtimeClasspath.getAttributes();
            for (Attribute attribute : sourceAttributes.keySet()) {
                attributes.attributeProvider(attribute, providers.provider((Callable<Object> & Serializable)() -> sourceAttributes.getAttribute(attribute)));
            }
        });
        productionRuntimeClasspath.setExtendsFrom((Iterable)runtimeClasspath.getExtendsFrom());
        productionRuntimeClasspath.setCanBeResolved(runtimeClasspath.isCanBeResolved());
        productionRuntimeClasspath.setCanBeConsumed(runtimeClasspath.isCanBeConsumed());
    }

    private void configureDevelopmentOnlyConfiguration(Project project) {
        Configuration developmentOnly = (Configuration)project.getConfigurations().create("developmentOnly");
        developmentOnly.setDescription("Configuration for development-only dependencies such as Spring Boot's DevTools.");
        Configuration runtimeClasspath = project.getConfigurations().getByName("runtimeClasspath");
        runtimeClasspath.extendsFrom(new Configuration[]{developmentOnly});
    }

    private void configureTestAndDevelopmentOnlyConfiguration(Project project) {
        Configuration testAndDevelopmentOnly = (Configuration)project.getConfigurations().create("testAndDevelopmentOnly");
        testAndDevelopmentOnly.setDescription("Configuration for test and development-only dependencies such as Spring Boot's DevTools.");
        Configuration runtimeClasspath = project.getConfigurations().getByName("runtimeClasspath");
        runtimeClasspath.extendsFrom(new Configuration[]{testAndDevelopmentOnly});
        Configuration testImplementation = project.getConfigurations().getByName("testImplementation");
        testImplementation.extendsFrom(new Configuration[]{testAndDevelopmentOnly});
    }

    private static final class AdditionalMetadataLocationsConfigurer
    implements Action<Task> {
        private final Set<File> locations;

        private AdditionalMetadataLocationsConfigurer(Set<File> locations) {
            this.locations = locations;
        }

        public void execute(Task task) {
            if (!(task instanceof JavaCompile)) {
                return;
            }
            JavaCompile compile = (JavaCompile)task;
            if (this.hasConfigurationProcessorOnClasspath(compile)) {
                this.configureAdditionalMetadataLocations(compile);
            }
        }

        private boolean hasConfigurationProcessorOnClasspath(JavaCompile compile) {
            Set files = compile.getOptions().getAnnotationProcessorPath() != null ? compile.getOptions().getAnnotationProcessorPath().getFiles() : compile.getClasspath().getFiles();
            return files.stream().map(File::getName).anyMatch((Predicate<String> & Serializable)name -> name.startsWith("spring-boot-configuration-processor"));
        }

        private void configureAdditionalMetadataLocations(JavaCompile compile) {
            compile.getOptions().getCompilerArgs().add("-Aorg.springframework.boot.configurationprocessor.additionalMetadataLocations=" + StringUtils.collectionToCommaDelimitedString(this.locations));
        }
    }
}

