/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.client5.http.entity.mime.AbstractContentBody;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.util.Args;
import org.gradle.internal.classpath.declarations.FileInputStreamInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

public class FileBody
extends AbstractContentBody {
    private final File file;
    private final String filename;

    public FileBody(File file) {
        this(file, ContentType.DEFAULT_BINARY, file != null ? file.getName() : null);
    }

    public FileBody(File file, ContentType contentType, String filename) {
        super(contentType);
        Args.notNull((Object)file, (String)"File");
        this.file = file;
        this.filename = filename == null ? file.getName() : filename;
    }

    public FileBody(File file, ContentType contentType) {
        this(file, contentType, file != null ? file.getName() : null);
    }

    public InputStream getInputStream() throws IOException {
        File file = this.file;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)fileInputStream, (File)file, (String)"org.apache.hc.client5.http.entity.mime.FileBody");
        return fileInputStream;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Args.notNull((Object)out, (String)"Output stream");
        File file = this.file;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)fileInputStream, (File)file, (String)"org.apache.hc.client5.http.entity.mime.FileBody");
        try (FileInputStream in = fileInputStream;){
            int l;
            byte[] tmp = new byte[4096];
            while ((l = ((InputStream)in).read(tmp)) != -1) {
                out.write(tmp, 0, l);
            }
            out.flush();
        }
    }

    @Override
    public long getContentLength() {
        return FileInterceptorsDeclaration.intercept_length((File)this.file, (String)"org.apache.hc.client5.http.entity.mime.FileBody");
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public File getFile() {
        return this.file;
    }
}

