/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.InvocationTargetException;
import org.gradle.internal.classpath.Instrumented;

public class NativeImageUtil {
    private static final boolean RUNNING_IN_SVM = Instrumented.systemProperty((String)"org.graalvm.nativeimage.imagecode", (String)"com.fasterxml.jackson.databind.util.NativeImageUtil") != null;

    private NativeImageUtil() {
    }

    private static boolean isRunningInNativeImage() {
        return RUNNING_IN_SVM && "runtime".equals(Instrumented.systemProperty((String)"org.graalvm.nativeimage.imagecode", (String)"com.fasterxml.jackson.databind.util.NativeImageUtil"));
    }

    public static boolean isUnsupportedFeatureError(Throwable e) {
        if (!NativeImageUtil.isRunningInNativeImage()) {
            return false;
        }
        if (e instanceof InvocationTargetException) {
            e = e.getCause();
        }
        return e.getClass().getName().equals("com.oracle.svm.core.jdk.UnsupportedFeatureError");
    }

    public static boolean needsReflectionConfiguration(Class<?> cl) {
        if (!NativeImageUtil.isRunningInNativeImage()) {
            return false;
        }
        return (cl.getDeclaredFields().length == 0 || ClassUtil.isRecordType(cl)) && cl.getDeclaredMethods().length == 0 && cl.getDeclaredConstructors().length == 0;
    }
}

