/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.strategy;

import java.lang.reflect.Field;
import org.gradle.internal.classpath.Instrumented;
import org.springframework.objenesis.ObjenesisException;

public final class PlatformDescription {
    public static final String GNU = "GNU libgcj";
    public static final String HOTSPOT = "Java HotSpot";
    @Deprecated
    public static final String SUN = "Java HotSpot";
    public static final String OPENJDK = "OpenJDK";
    public static final String PERC = "PERC";
    public static final String DALVIK = "Dalvik";
    public static final String SPECIFICATION_VERSION = Instrumented.systemProperty((String)"java.specification.version", (String)"org.springframework.objenesis.strategy.PlatformDescription");
    public static final String VM_VERSION = Instrumented.systemProperty((String)"java.runtime.version", (String)"org.springframework.objenesis.strategy.PlatformDescription");
    public static final String VM_INFO = Instrumented.systemProperty((String)"java.vm.info", (String)"org.springframework.objenesis.strategy.PlatformDescription");
    public static final String VENDOR_VERSION = Instrumented.systemProperty((String)"java.vm.version", (String)"org.springframework.objenesis.strategy.PlatformDescription");
    public static final String VENDOR = Instrumented.systemProperty((String)"java.vm.vendor", (String)"org.springframework.objenesis.strategy.PlatformDescription");
    public static final String JVM_NAME = Instrumented.systemProperty((String)"java.vm.name", (String)"org.springframework.objenesis.strategy.PlatformDescription");
    public static final int ANDROID_VERSION = PlatformDescription.getAndroidVersion();
    public static final boolean IS_ANDROID_OPENJDK = PlatformDescription.getIsAndroidOpenJDK();
    @Deprecated
    public static final String GAE_VERSION = PlatformDescription.getGaeRuntimeVersion();

    public static String describePlatform() {
        String desc = "Java " + SPECIFICATION_VERSION + " (VM vendor name=\"" + VENDOR + "\", VM vendor version=" + VENDOR_VERSION + ", JVM name=\"" + JVM_NAME + "\", JVM version=" + VM_VERSION + ", JVM info=" + VM_INFO;
        if (ANDROID_VERSION != 0) {
            desc = desc + ", API level=" + ANDROID_VERSION;
        }
        desc = desc + ")";
        return desc;
    }

    public static boolean isThisJVM(String name) {
        return JVM_NAME.startsWith(name);
    }

    public static boolean isAndroidOpenJDK() {
        return IS_ANDROID_OPENJDK;
    }

    private static boolean getIsAndroidOpenJDK() {
        if (PlatformDescription.getAndroidVersion() == 0) {
            return false;
        }
        String bootClasspath = Instrumented.systemProperty((String)"java.boot.class.path", (String)"org.springframework.objenesis.strategy.PlatformDescription");
        return bootClasspath != null && bootClasspath.toLowerCase().contains("core-oj.jar");
    }

    public static boolean isAfterJigsaw() {
        String version = SPECIFICATION_VERSION;
        return version.indexOf(46) < 0;
    }

    public static boolean isAfterJava11() {
        if (!PlatformDescription.isAfterJigsaw()) {
            return false;
        }
        int version = Integer.parseInt(SPECIFICATION_VERSION);
        return version >= 11;
    }

    @Deprecated
    public static boolean isGoogleAppEngine() {
        return GAE_VERSION != null;
    }

    @Deprecated
    private static String getGaeRuntimeVersion() {
        return Instrumented.systemProperty((String)"com.google.appengine.runtime.version", (String)"org.springframework.objenesis.strategy.PlatformDescription");
    }

    private static int getAndroidVersion() {
        if (!PlatformDescription.isThisJVM(DALVIK)) {
            return 0;
        }
        return PlatformDescription.getAndroidVersion0();
    }

    private static int getAndroidVersion0() {
        int version;
        Field field;
        Class<?> clazz;
        try {
            clazz = Class.forName("android.os.Build$VERSION");
        }
        catch (ClassNotFoundException e) {
            throw new ObjenesisException(e);
        }
        try {
            field = clazz.getField("SDK_INT");
        }
        catch (NoSuchFieldException e) {
            return PlatformDescription.getOldAndroidVersion(clazz);
        }
        try {
            version = (Integer)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return version;
    }

    private static int getOldAndroidVersion(Class<?> versionClass) {
        String version;
        Field field;
        try {
            field = versionClass.getField("SDK");
        }
        catch (NoSuchFieldException e) {
            throw new ObjenesisException(e);
        }
        try {
            version = (String)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return Integer.parseInt(version);
    }

    private PlatformDescription() {
    }
}

