/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class InputStreamResource
extends AbstractResource {
    private final InputStreamSource inputStreamSource;
    private final String description;
    private final Object equality;
    private boolean read = false;

    public InputStreamResource(InputStreamSource inputStreamSource) {
        this(inputStreamSource, "resource loaded from InputStreamSource");
    }

    public InputStreamResource(InputStreamSource inputStreamSource, @Nullable String description) {
        Assert.notNull((Object)inputStreamSource, "InputStreamSource must not be null");
        this.inputStreamSource = inputStreamSource;
        this.description = description != null ? description : "";
        this.equality = inputStreamSource;
    }

    public InputStreamResource(InputStream inputStream) {
        this(inputStream, "resource loaded through InputStream");
    }

    public InputStreamResource(InputStream inputStream, @Nullable String description) {
        Assert.notNull((Object)inputStream, "InputStream must not be null");
        this.inputStreamSource = (InputStreamSource & Serializable)() -> inputStream;
        this.description = description != null ? description : "";
        this.equality = inputStream;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public InputStream getInputStream() throws IOException, IllegalStateException {
        if (this.read) {
            throw new IllegalStateException("InputStream has already been read (possibly for early content length determination) - do not use InputStreamResource if a stream needs to be read multiple times");
        }
        this.read = true;
        return this.inputStreamSource.getInputStream();
    }

    @Override
    public String getDescription() {
        return "InputStream resource [" + this.description + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof InputStreamResource)) return false;
        InputStreamResource that = (InputStreamResource)other;
        if (!this.equality.equals(that.equality)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.equality.hashCode();
    }
}

