/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.WritableResource;
import org.springframework.lang.Nullable;

public class FileUrlResource
extends UrlResource
implements WritableResource {
    @Nullable
    private volatile File file;

    public FileUrlResource(URL url) {
        super(url);
    }

    public FileUrlResource(String location) throws MalformedURLException {
        super("file", location);
    }

    @Override
    public File getFile() throws IOException {
        File file = this.file;
        if (file != null) {
            return file;
        }
        this.file = file = super.getFile();
        return file;
    }

    @Override
    public boolean isWritable() {
        try {
            File file = this.getFile();
            return file.canWrite() && !FileInterceptorsDeclaration.intercept_isDirectory((File)file, (String)"org.springframework.core.io.FileUrlResource");
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.getFile().toPath(), new OpenOption[0]);
    }

    @Override
    public WritableByteChannel writableChannel() throws IOException {
        return NioFileInterceptors.intercept_open((Path)this.getFile().toPath(), (OpenOption[])new OpenOption[]{StandardOpenOption.WRITE}, (String)"org.springframework.core.io.FileUrlResource");
    }

    @Override
    public Resource createRelative(String relativePath) throws MalformedURLException {
        return new FileUrlResource(this.createRelativeURL(relativePath));
    }
}

