/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collector;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public abstract class MergedAnnotationCollectors {
    private static final Collector.Characteristics[] NO_CHARACTERISTICS = new Collector.Characteristics[0];
    private static final Collector.Characteristics[] IDENTITY_FINISH_CHARACTERISTICS = new Collector.Characteristics[]{Collector.Characteristics.IDENTITY_FINISH};

    private MergedAnnotationCollectors() {
    }

    public static <A extends Annotation> Collector<MergedAnnotation<A>, ?, Set<A>> toAnnotationSet() {
        return Collector.of(LinkedHashSet::new, (BiConsumer<Set, MergedAnnotation> & Serializable)(set, annotation) -> set.add(annotation.synthesize()), MergedAnnotationCollectors::combiner, new Collector.Characteristics[0]);
    }

    public static <A extends Annotation> Collector<MergedAnnotation<A>, ?, Annotation[]> toAnnotationArray() {
        return MergedAnnotationCollectors.toAnnotationArray((IntFunction<R[]>)((IntFunction<Annotation[]> & Serializable)(Annotation[]::new)));
    }

    public static <R extends Annotation, A extends R> Collector<MergedAnnotation<A>, ?, R[]> toAnnotationArray(IntFunction<R[]> generator) {
        return Collector.of(ArrayList::new, (BiConsumer<ArrayList, MergedAnnotation> & Serializable)(list, annotation) -> list.add(annotation.synthesize()), MergedAnnotationCollectors::combiner, (Function<ArrayList, Annotation[]> & Serializable)list -> list.toArray((Annotation[])generator.apply(list.size())), new Collector.Characteristics[0]);
    }

    public static <A extends Annotation> Collector<MergedAnnotation<A>, ?, MultiValueMap<String, Object>> toMultiValueMap(MergedAnnotation.Adapt ... adaptations) {
        return MergedAnnotationCollectors.toMultiValueMap(Function.identity(), adaptations);
    }

    public static <A extends Annotation> Collector<MergedAnnotation<A>, ?, MultiValueMap<String, Object>> toMultiValueMap(Function<MultiValueMap<String, Object>, MultiValueMap<String, Object>> finisher, MergedAnnotation.Adapt ... adaptations) {
        Collector.Characteristics[] characteristics = MergedAnnotationCollectors.isSameInstance(finisher, Function.identity()) ? IDENTITY_FINISH_CHARACTERISTICS : NO_CHARACTERISTICS;
        return Collector.of(LinkedMultiValueMap::new, (BiConsumer<MultiValueMap, MergedAnnotation> & Serializable)(map, annotation) -> annotation.asMap(adaptations).forEach(map::add), MergedAnnotationCollectors::combiner, finisher, characteristics);
    }

    private static boolean isSameInstance(Object instance, Object candidate) {
        return instance == candidate;
    }

    private static <E, C extends Collection<E>> C combiner(C collection, C additions) {
        collection.addAll(additions);
        return collection;
    }

    private static <K, V> MultiValueMap<K, V> combiner(MultiValueMap<K, V> map, MultiValueMap<K, V> additions) {
        map.addAll(additions);
        return map;
    }
}

