/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function2;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.full.KTypes;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.reactor.MonoKt;
import kotlinx.coroutines.reactor.ReactorFlowKt;
import org.reactivestreams.Publisher;
import org.springframework.core.KotlinDetector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class CoroutinesUtils {
    private static final KType flowType = KClassifiers.getStarProjectedType((KClassifier)JvmClassMappingKt.getKotlinClass(Flow.class));
    private static final KType monoType = KClassifiers.getStarProjectedType((KClassifier)JvmClassMappingKt.getKotlinClass(Mono.class));
    private static final KType publisherType = KClassifiers.getStarProjectedType((KClassifier)JvmClassMappingKt.getKotlinClass(Publisher.class));

    public static <T> Mono<T> deferredToMono(Deferred<T> source) {
        return MonoKt.mono((CoroutineContext)Dispatchers.getUnconfined(), (Function2 & Serializable)(scope, continuation) -> source.await(continuation));
    }

    public static <T> Deferred<T> monoToDeferred(Mono<T> source) {
        return BuildersKt.async((CoroutineScope)GlobalScope.INSTANCE, (CoroutineContext)Dispatchers.getUnconfined(), (CoroutineStart)CoroutineStart.DEFAULT, (Function2 & Serializable)(scope, continuation) -> MonoKt.awaitSingleOrNull((Mono)source, (Continuation)continuation));
    }

    public static Publisher<?> invokeSuspendingFunction(Method method, Object target, Object ... args) {
        return CoroutinesUtils.invokeSuspendingFunction((CoroutineContext)Dispatchers.getUnconfined(), method, target, args);
    }

    public static Publisher<?> invokeSuspendingFunction(CoroutineContext context, Method method, @Nullable Object target, Object ... args) {
        Assert.isTrue(KotlinDetector.isSuspendingFunction(method), "Method must be a suspending function");
        KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method);
        Assert.notNull((Object)function, (Supplier<String> & Serializable)() -> "Failed to get Kotlin function for method: " + method);
        if (method.isAccessible() && !KCallablesJvm.isAccessible((KCallable)function)) {
            KCallablesJvm.setAccessible((KCallable)function, (boolean)true);
        }
        Mono mono = MonoKt.mono((CoroutineContext)context, (Function2 & Serializable)(scope, continuation) -> {
            HashMap<KParameter, Object> argMap = CollectionUtils.newHashMap(args.length + 1);
            int index = 0;
            for (KParameter parameter : function.getParameters()) {
                switch (parameter.getKind()) {
                    case INSTANCE: {
                        argMap.put(parameter, target);
                        break;
                    }
                    case VALUE: 
                    case EXTENSION_RECEIVER: {
                        Object arg = args[index];
                        if (!parameter.isOptional() || arg != null) {
                            KClass kClass;
                            KClassifier patt5429$temp;
                            KType type = parameter.getType();
                            if ((!type.isMarkedNullable() || arg != null) && (patt5429$temp = type.getClassifier()) instanceof KClass && KotlinDetector.isInlineClass(JvmClassMappingKt.getJavaClass((KClass)(kClass = (KClass)patt5429$temp)))) {
                                KFunction constructor = KClasses.getPrimaryConstructor((KClass)kClass);
                                if (!KCallablesJvm.isAccessible((KCallable)constructor)) {
                                    KCallablesJvm.setAccessible((KCallable)constructor, (boolean)true);
                                }
                                arg = constructor.call(new Object[]{arg});
                            }
                            argMap.put(parameter, arg);
                        }
                        ++index;
                    }
                }
            }
            return KCallables.callSuspendBy((KCallable)function, argMap, (Continuation)continuation);
        }).filter((Predicate<Object> & Serializable)result -> result != Unit.INSTANCE).onErrorMap(InvocationTargetException.class, InvocationTargetException::getTargetException);
        KType returnType = function.getReturnType();
        if (KTypes.isSubtypeOf((KType)returnType, (KType)flowType)) {
            return mono.flatMapMany(CoroutinesUtils::asFlux);
        }
        if (KTypes.isSubtypeOf((KType)returnType, (KType)publisherType)) {
            if (KTypes.isSubtypeOf((KType)returnType, (KType)monoType)) {
                return mono.flatMap((Function<Object, Mono> & Serializable)o -> (Mono)o);
            }
            return mono.flatMapMany((Function<Object, Publisher> & Serializable)o -> (Publisher)o);
        }
        return mono;
    }

    private static Flux<?> asFlux(Object flow) {
        return ReactorFlowKt.asFlux((Flow)((Flow)flow));
    }
}

