/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.nativex;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.aot.hint.ExecutableHint;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.FieldHint;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.MemberHint;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.aot.nativex.BasicJsonWriter;
import org.springframework.lang.Nullable;

class ReflectionHintsWriter {
    public static final ReflectionHintsWriter INSTANCE = new ReflectionHintsWriter();

    ReflectionHintsWriter() {
    }

    public void write(BasicJsonWriter writer, ReflectionHints hints) {
        writer.writeArray(hints.typeHints().sorted(Comparator.comparing(TypeHint::getType)).map(this::toAttributes).toList());
    }

    private Map<String, Object> toAttributes(TypeHint hint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put("name", hint.getType());
        this.handleCondition(attributes, hint);
        this.handleCategories(attributes, hint.getMemberCategories());
        this.handleFields(attributes, hint.fields());
        this.handleExecutables(attributes, Stream.concat(hint.constructors(), hint.methods()).sorted().toList());
        return attributes;
    }

    private void handleCondition(Map<String, Object> attributes, TypeHint hint) {
        if (hint.getReachableType() != null) {
            LinkedHashMap<String, TypeReference> conditionAttributes = new LinkedHashMap<String, TypeReference>();
            conditionAttributes.put("typeReachable", hint.getReachableType());
            attributes.put("condition", conditionAttributes);
        }
    }

    private void handleFields(Map<String, Object> attributes, Stream<FieldHint> fields) {
        this.addIfNotEmpty(attributes, "fields", fields.sorted(Comparator.comparing(MemberHint::getName, String::compareToIgnoreCase)).map(this::toAttributes).toList());
    }

    private Map<String, Object> toAttributes(FieldHint hint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put("name", hint.getName());
        return attributes;
    }

    private void handleExecutables(Map<String, Object> attributes, List<ExecutableHint> hints) {
        this.addIfNotEmpty(attributes, "methods", hints.stream().filter((Predicate<ExecutableHint> & Serializable)h -> h.getMode().equals((Object)ExecutableMode.INVOKE)).map(this::toAttributes).toList());
        this.addIfNotEmpty(attributes, "queriedMethods", hints.stream().filter((Predicate<ExecutableHint> & Serializable)h -> h.getMode().equals((Object)ExecutableMode.INTROSPECT)).map(this::toAttributes).toList());
    }

    private Map<String, Object> toAttributes(ExecutableHint hint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put("name", hint.getName());
        attributes.put("parameterTypes", hint.getParameterTypes());
        return attributes;
    }

    private void handleCategories(Map<String, Object> attributes, Set<MemberCategory> categories) {
        categories.stream().sorted().forEach((Consumer<MemberCategory> & Serializable)category -> {
            switch (category) {
                case PUBLIC_FIELDS: {
                    attributes.put("allPublicFields", true);
                    break;
                }
                case DECLARED_FIELDS: {
                    attributes.put("allDeclaredFields", true);
                    break;
                }
                case INTROSPECT_PUBLIC_CONSTRUCTORS: {
                    attributes.put("queryAllPublicConstructors", true);
                    break;
                }
                case INTROSPECT_DECLARED_CONSTRUCTORS: {
                    attributes.put("queryAllDeclaredConstructors", true);
                    break;
                }
                case INVOKE_PUBLIC_CONSTRUCTORS: {
                    attributes.put("allPublicConstructors", true);
                    break;
                }
                case INVOKE_DECLARED_CONSTRUCTORS: {
                    attributes.put("allDeclaredConstructors", true);
                    break;
                }
                case INTROSPECT_PUBLIC_METHODS: {
                    attributes.put("queryAllPublicMethods", true);
                    break;
                }
                case INTROSPECT_DECLARED_METHODS: {
                    attributes.put("queryAllDeclaredMethods", true);
                    break;
                }
                case INVOKE_PUBLIC_METHODS: {
                    attributes.put("allPublicMethods", true);
                    break;
                }
                case INVOKE_DECLARED_METHODS: {
                    attributes.put("allDeclaredMethods", true);
                    break;
                }
                case PUBLIC_CLASSES: {
                    attributes.put("allPublicClasses", true);
                    break;
                }
                case DECLARED_CLASSES: {
                    attributes.put("allDeclaredClasses", true);
                }
            }
        });
    }

    private void addIfNotEmpty(Map<String, Object> attributes, String name, @Nullable Object value) {
        Collection collection;
        if (value != null && value instanceof Collection && !(collection = (Collection)value).isEmpty()) {
            attributes.put(name, value);
        }
    }
}

