/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.nativex;

import java.io.Serializable;
import java.util.function.Consumer;
import org.springframework.aot.hint.ProxyHints;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.ResourceHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.SerializationHints;
import org.springframework.aot.nativex.BasicJsonWriter;
import org.springframework.aot.nativex.ProxyHintsWriter;
import org.springframework.aot.nativex.ReflectionHintsWriter;
import org.springframework.aot.nativex.ResourceHintsWriter;
import org.springframework.aot.nativex.SerializationHintsWriter;

public abstract class NativeConfigurationWriter {
    public void write(RuntimeHints hints) {
        if (hints.serialization().javaSerializationHints().findAny().isPresent()) {
            this.writeSerializationHints(hints.serialization());
        }
        if (hints.proxies().jdkProxyHints().findAny().isPresent()) {
            this.writeProxyHints(hints.proxies());
        }
        if (hints.reflection().typeHints().findAny().isPresent()) {
            this.writeReflectionHints(hints.reflection());
        }
        if (hints.resources().resourcePatternHints().findAny().isPresent() || hints.resources().resourceBundleHints().findAny().isPresent()) {
            this.writeResourceHints(hints.resources());
        }
        if (hints.jni().typeHints().findAny().isPresent()) {
            this.writeJniHints(hints.jni());
        }
    }

    protected abstract void writeTo(String var1, Consumer<BasicJsonWriter> var2);

    private void writeSerializationHints(SerializationHints hints) {
        this.writeTo("serialization-config.json", (Consumer<BasicJsonWriter> & Serializable)writer -> SerializationHintsWriter.INSTANCE.write((BasicJsonWriter)writer, hints));
    }

    private void writeProxyHints(ProxyHints hints) {
        this.writeTo("proxy-config.json", (Consumer<BasicJsonWriter> & Serializable)writer -> ProxyHintsWriter.INSTANCE.write((BasicJsonWriter)writer, hints));
    }

    private void writeReflectionHints(ReflectionHints hints) {
        this.writeTo("reflect-config.json", (Consumer<BasicJsonWriter> & Serializable)writer -> ReflectionHintsWriter.INSTANCE.write((BasicJsonWriter)writer, hints));
    }

    private void writeResourceHints(ResourceHints hints) {
        this.writeTo("resource-config.json", (Consumer<BasicJsonWriter> & Serializable)writer -> ResourceHintsWriter.INSTANCE.write((BasicJsonWriter)writer, hints));
    }

    private void writeJniHints(ReflectionHints hints) {
        this.writeTo("jni-config.json", (Consumer<BasicJsonWriter> & Serializable)writer -> ReflectionHintsWriter.INSTANCE.write((BasicJsonWriter)writer, hints));
    }
}

