/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.support;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;

class ObjectToObjectConverterRuntimeHints
implements RuntimeHintsRegistrar {
    ObjectToObjectConverterRuntimeHints() {
    }

    @Override
    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        ReflectionHints reflectionHints = hints.reflection();
        TypeReference sqlDateTypeReference = TypeReference.of("java.sql.Date");
        reflectionHints.registerTypeIfPresent(classLoader, sqlDateTypeReference.getName(), (Consumer<TypeHint.Builder> & Serializable)hint -> hint.withMethod("toLocalDate", Collections.emptyList(), ExecutableMode.INVOKE).onReachableType(sqlDateTypeReference).withMethod("valueOf", List.of(TypeReference.of(LocalDate.class)), ExecutableMode.INVOKE).onReachableType(sqlDateTypeReference));
        reflectionHints.registerTypeIfPresent(classLoader, "org.springframework.http.HttpMethod", (Consumer<TypeHint.Builder> & Serializable)builder -> builder.withMethod("valueOf", List.of(TypeReference.of(String.class)), ExecutableMode.INVOKE));
        reflectionHints.registerTypeIfPresent(classLoader, "java.net.URI", MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
    }
}

