/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.support;

import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.function.Consumer;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeHint;
import org.springframework.util.ClassUtils;

public abstract class ClassHintUtils {
    private static final Consumer<TypeHint.Builder> asClassBasedProxy = (Consumer<TypeHint.Builder> & Serializable)hint -> hint.withMembers(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS);
    private static final Consumer<TypeHint.Builder> asProxiedUserClass = (Consumer<TypeHint.Builder> & Serializable)hint -> hint.withMembers(MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.INVOKE_DECLARED_METHODS);

    public static void registerProxyIfNecessary(Class<?> candidateClass, RuntimeHints runtimeHints) {
        if (Proxy.isProxyClass(candidateClass)) {
            runtimeHints.proxies().registerJdkProxy(candidateClass.getInterfaces());
        } else {
            Class<?> userClass = ClassUtils.getUserClass(candidateClass);
            if (userClass != candidateClass) {
                runtimeHints.reflection().registerType(candidateClass, asClassBasedProxy).registerType(userClass, asProxiedUserClass);
            }
        }
    }
}

