/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.predicate;

import java.io.Serializable;
import java.util.function.Predicate;
import org.springframework.aot.hint.JavaSerializationHint;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.util.Assert;

public class SerializationHintsPredicates {
    SerializationHintsPredicates() {
    }

    public Predicate<RuntimeHints> onType(Class<?> type) {
        Assert.notNull(type, "'type' must not be null");
        return this.onType(TypeReference.of(type));
    }

    public Predicate<RuntimeHints> onType(TypeReference typeReference) {
        Assert.notNull((Object)typeReference, "'typeReference' must not be null");
        return (Predicate<RuntimeHints> & Serializable)hints -> hints.serialization().javaSerializationHints().anyMatch((Predicate<JavaSerializationHint> & Serializable)hint -> hint.getType().equals(typeReference));
    }
}

