/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.predicate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.aot.hint.ResourceBundleHint;
import org.springframework.aot.hint.ResourceHints;
import org.springframework.aot.hint.ResourcePatternHint;
import org.springframework.aot.hint.ResourcePatternHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentLruCache;

public class ResourceHintsPredicates {
    private static final ConcurrentLruCache<ResourcePatternHint, Pattern> CACHED_RESOURCE_PATTERNS = new ConcurrentLruCache(32, ResourcePatternHint::toRegex);

    ResourceHintsPredicates() {
    }

    public Predicate<RuntimeHints> forBundle(String bundleName) {
        Assert.hasText(bundleName, "resource bundle name should not be empty");
        return (Predicate<RuntimeHints> & Serializable)runtimeHints -> runtimeHints.resources().resourceBundleHints().anyMatch((Predicate<ResourceBundleHint> & Serializable)bundleHint -> bundleName.equals(bundleHint.getBaseName()));
    }

    public Predicate<RuntimeHints> forResource(TypeReference type, String resourceName) {
        String absoluteName = this.resolveAbsoluteResourceName(type, resourceName);
        return this.forResource(absoluteName);
    }

    private String resolveAbsoluteResourceName(TypeReference type, String resourceName) {
        if (resourceName.startsWith("/")) {
            return resourceName.substring(1);
        }
        if (type.getPackageName().isEmpty()) {
            return resourceName;
        }
        return type.getPackageName().replace('.', '/') + "/" + resourceName;
    }

    public Predicate<RuntimeHints> forResource(String resourceName) {
        String resourceNameToUse = resourceName.startsWith("/") ? resourceName.substring(1) : resourceName;
        return (Predicate<RuntimeHints> & Serializable)hints -> {
            AggregatedResourcePatternHints aggregatedResourcePatternHints = AggregatedResourcePatternHints.of(hints.resources());
            boolean isExcluded = aggregatedResourcePatternHints.excludes().stream().anyMatch((Predicate<ResourcePatternHint> & Serializable)excluded -> CACHED_RESOURCE_PATTERNS.get((ResourcePatternHint)excluded).matcher(resourceNameToUse).matches());
            if (isExcluded) {
                return false;
            }
            return aggregatedResourcePatternHints.includes().stream().anyMatch((Predicate<ResourcePatternHint> & Serializable)included -> CACHED_RESOURCE_PATTERNS.get((ResourcePatternHint)included).matcher(resourceNameToUse).matches());
        };
    }

    private record AggregatedResourcePatternHints(List<ResourcePatternHint> includes, List<ResourcePatternHint> excludes) {
        static AggregatedResourcePatternHints of(ResourceHints resourceHints) {
            ArrayList<ResourcePatternHint> includes = new ArrayList<ResourcePatternHint>();
            ArrayList<ResourcePatternHint> excludes = new ArrayList<ResourcePatternHint>();
            resourceHints.resourcePatternHints().forEach((Consumer<ResourcePatternHints> & Serializable)resourcePatternHint -> {
                includes.addAll(resourcePatternHint.getIncludes());
                excludes.addAll(resourcePatternHint.getExcludes());
            });
            return new AggregatedResourcePatternHints(includes, excludes);
        }
    }
}

