/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.predicate;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.springframework.aot.hint.JdkProxyHint;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.util.Assert;

public class ProxyHintsPredicates {
    ProxyHintsPredicates() {
    }

    public Predicate<RuntimeHints> forInterfaces(Class<?> ... interfaces) {
        Assert.notEmpty((Object[])interfaces, "'interfaces' should not be empty");
        return this.forInterfaces((TypeReference[])Arrays.stream(interfaces).map(TypeReference::of).toArray((IntFunction<A[]>)((IntFunction<TypeReference[]> & Serializable)(TypeReference[]::new))));
    }

    public Predicate<RuntimeHints> forInterfaces(TypeReference ... interfaces) {
        Assert.notEmpty((Object[])interfaces, "'interfaces' should not be empty");
        List<TypeReference> interfaceList = Arrays.asList(interfaces);
        return (Predicate<RuntimeHints> & Serializable)hints -> hints.proxies().jdkProxyHints().anyMatch((Predicate<JdkProxyHint> & Serializable)proxyHint -> proxyHint.getProxiedInterfaces().equals(interfaceList));
    }
}

