/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.annotation;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.annotation.Reflective;
import org.springframework.aot.hint.annotation.ReflectiveProcessor;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ReflectiveRuntimeHintsRegistrar {
    private final Map<Class<? extends ReflectiveProcessor>, ReflectiveProcessor> processors = new HashMap<Class<? extends ReflectiveProcessor>, ReflectiveProcessor>();

    public void registerRuntimeHints(RuntimeHints runtimeHints, Class<?> ... types) {
        HashSet<Entry> entries = new HashSet<Entry>();
        for (Class<?> type : types) {
            this.processType(entries, type);
            for (Class<?> implementedInterface : ClassUtils.getAllInterfacesForClass(type)) {
                this.processType(entries, implementedInterface);
            }
        }
        entries.forEach((Consumer<Entry> & Serializable)entry -> {
            AnnotatedElement element = entry.element();
            entry.processor().registerReflectionHints(runtimeHints.reflection(), element);
        });
    }

    private void processType(Set<Entry> entries, Class<?> typeToProcess) {
        if (this.isReflective(typeToProcess)) {
            entries.add(this.createEntry(typeToProcess));
        }
        this.doWithReflectiveConstructors(typeToProcess, (Consumer<Constructor> & Serializable)constructor -> entries.add(this.createEntry((AnnotatedElement)constructor)));
        ReflectionUtils.doWithFields(typeToProcess, (ReflectionUtils.FieldCallback & Serializable)field -> entries.add(this.createEntry(field)), this::isReflective);
        ReflectionUtils.doWithMethods(typeToProcess, (ReflectionUtils.MethodCallback & Serializable)method -> entries.add(this.createEntry(method)), this::isReflective);
    }

    private void doWithReflectiveConstructors(Class<?> typeToProcess, Consumer<Constructor<?>> consumer) {
        for (Constructor<?> constructor : typeToProcess.getDeclaredConstructors()) {
            if (!this.isReflective(constructor)) continue;
            consumer.accept(constructor);
        }
    }

    private boolean isReflective(AnnotatedElement element) {
        return MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(Reflective.class);
    }

    private Entry createEntry(AnnotatedElement element) {
        List<ReflectiveProcessor> processors = MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).stream(Reflective.class).map((Function<MergedAnnotation, Class[]> & Serializable)annotation -> annotation.getClassArray("value")).flatMap(Arrays::stream).distinct().map((Function<Class, Class> & Serializable)type -> type).map((Function<Class, ReflectiveProcessor> & Serializable)processorClass -> this.processors.computeIfAbsent((Class<? extends ReflectiveProcessor>)processorClass, (Function<Class<? extends ReflectiveProcessor>, ReflectiveProcessor>)((Function<Class, ReflectiveProcessor> & Serializable)this::instantiateClass))).toList();
        ReflectiveProcessor processorToUse = processors.size() == 1 ? (ReflectiveProcessor)processors.get(0) : new DelegatingReflectiveProcessor(processors);
        return new Entry(element, processorToUse);
    }

    private ReflectiveProcessor instantiateClass(Class<? extends ReflectiveProcessor> type) {
        try {
            Constructor<? extends ReflectiveProcessor> constructor = type.getDeclaredConstructor(new Class[0]);
            ReflectionUtils.makeAccessible(constructor);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to instantiate " + type, ex);
        }
    }

    private record Entry(AnnotatedElement element, ReflectiveProcessor processor) {
    }

    private static class DelegatingReflectiveProcessor
    implements ReflectiveProcessor {
        private final Iterable<ReflectiveProcessor> processors;

        DelegatingReflectiveProcessor(Iterable<ReflectiveProcessor> processors) {
            this.processors = processors;
        }

        @Override
        public void registerReflectionHints(ReflectionHints hints, AnnotatedElement element) {
            this.processors.forEach((Consumer<ReflectiveProcessor> & Serializable)processor -> processor.registerReflectionHints(hints, element));
        }
    }
}

