/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.springframework.aot.hint.ConditionalHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;

public final class JdkProxyHint
implements ConditionalHint {
    private final List<TypeReference> proxiedInterfaces;
    @Nullable
    private final TypeReference reachableType;

    private JdkProxyHint(Builder builder) {
        this.proxiedInterfaces = List.copyOf(builder.proxiedInterfaces);
        this.reachableType = builder.reachableType;
    }

    public static Builder of(TypeReference ... proxiedInterfaces) {
        return new Builder().proxiedInterfaces(proxiedInterfaces);
    }

    public static Builder of(Class<?> ... proxiedInterfaces) {
        return new Builder().proxiedInterfaces(proxiedInterfaces);
    }

    public List<TypeReference> getProxiedInterfaces() {
        return this.proxiedInterfaces;
    }

    @Override
    @Nullable
    public TypeReference getReachableType() {
        return this.reachableType;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdkProxyHint that = (JdkProxyHint)o;
        return this.proxiedInterfaces.equals(that.proxiedInterfaces) && Objects.equals(this.reachableType, that.reachableType);
    }

    public int hashCode() {
        return Objects.hash(this.proxiedInterfaces);
    }

    public static class Builder {
        private final LinkedList<TypeReference> proxiedInterfaces = new LinkedList();
        @Nullable
        private TypeReference reachableType;

        Builder() {
        }

        public Builder proxiedInterfaces(TypeReference ... proxiedInterfaces) {
            this.proxiedInterfaces.addAll(Arrays.asList(proxiedInterfaces));
            return this;
        }

        public Builder proxiedInterfaces(Class<?> ... proxiedInterfaces) {
            this.proxiedInterfaces.addAll(Builder.toTypeReferences(proxiedInterfaces));
            return this;
        }

        public Builder onReachableType(TypeReference reachableType) {
            this.reachableType = reachableType;
            return this;
        }

        JdkProxyHint build() {
            return new JdkProxyHint(this);
        }

        private static List<TypeReference> toTypeReferences(Class<?> ... proxiedInterfaces) {
            List invalidTypes = Arrays.stream(proxiedInterfaces).filter((Predicate<Class> & Serializable)candidate -> !candidate.isInterface() || candidate.isSealed()).map(Class::getName).toList();
            if (!invalidTypes.isEmpty()) {
                throw new IllegalArgumentException("The following must be non-sealed interfaces: " + invalidTypes);
            }
            return TypeReference.listOf(proxiedInterfaces);
        }
    }
}

