/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.generate;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.core.io.InputStreamSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class InMemoryGeneratedFiles
implements GeneratedFiles {
    private final Map<GeneratedFiles.Kind, Map<String, InputStreamSource>> files = new HashMap<GeneratedFiles.Kind, Map<String, InputStreamSource>>();

    @Override
    public void addFile(GeneratedFiles.Kind kind, String path, InputStreamSource content) {
        Assert.notNull((Object)kind, "'kind' must not be null");
        Assert.hasLength(path, "'path' must not be empty");
        Assert.notNull((Object)content, "'content' must not be null");
        Map<String, InputStreamSource> paths = this.files.computeIfAbsent(kind, (Function<GeneratedFiles.Kind, Map<String, InputStreamSource>>)(Function<GeneratedFiles.Kind, Map> & Serializable)key -> new LinkedHashMap());
        Assert.state(!paths.containsKey(path), (Supplier<String> & Serializable)() -> "Path '" + path + "' already in use");
        paths.put(path, content);
    }

    public Map<String, InputStreamSource> getGeneratedFiles(GeneratedFiles.Kind kind) {
        Assert.notNull((Object)kind, "'kind' must not be null");
        return Collections.unmodifiableMap(this.files.getOrDefault((Object)kind, Collections.emptyMap()));
    }

    @Nullable
    public String getGeneratedFileContent(GeneratedFiles.Kind kind, String path) throws IOException {
        InputStreamSource source = this.getGeneratedFile(kind, path);
        if (source != null) {
            return new String(source.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
        }
        return null;
    }

    @Nullable
    public InputStreamSource getGeneratedFile(GeneratedFiles.Kind kind, String path) {
        Assert.notNull((Object)kind, "'kind' must not be null");
        Assert.hasLength(path, "'path' must not be empty");
        Map<String, InputStreamSource> paths = this.files.get((Object)kind);
        return paths != null ? paths.get(path) : null;
    }
}

