/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.generate;

import java.io.Serializable;
import org.springframework.aot.generate.AppendableConsumerInputStreamSource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.javapoet.JavaFile;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.function.ThrowingConsumer;

public interface GeneratedFiles {
    default public void addSourceFile(JavaFile javaFile) {
        GeneratedFiles.validatePackage(javaFile.packageName, javaFile.typeSpec.name);
        String className = javaFile.packageName + "." + javaFile.typeSpec.name;
        this.addSourceFile(className, javaFile::writeTo);
    }

    default public void addSourceFile(String className, CharSequence content) {
        this.addSourceFile(className, (ThrowingConsumer<Appendable> & Serializable)(Appendable appendable) -> appendable.append(content));
    }

    default public void addSourceFile(String className, ThrowingConsumer<Appendable> content) {
        this.addFile(Kind.SOURCE, GeneratedFiles.getClassNamePath(className), content);
    }

    default public void addSourceFile(String className, InputStreamSource content) {
        this.addFile(Kind.SOURCE, GeneratedFiles.getClassNamePath(className), content);
    }

    default public void addResourceFile(String path, CharSequence content) {
        this.addResourceFile(path, (ThrowingConsumer<Appendable> & Serializable)(Appendable appendable) -> appendable.append(content));
    }

    default public void addResourceFile(String path, ThrowingConsumer<Appendable> content) {
        this.addFile(Kind.RESOURCE, path, content);
    }

    default public void addResourceFile(String path, InputStreamSource content) {
        this.addFile(Kind.RESOURCE, path, content);
    }

    default public void addClassFile(String path, InputStreamSource content) {
        this.addFile(Kind.CLASS, path, content);
    }

    default public void addFile(Kind kind, String path, CharSequence content) {
        this.addFile(kind, path, (ThrowingConsumer<Appendable> & Serializable)(Appendable appendable) -> appendable.append(content));
    }

    default public void addFile(Kind kind, String path, ThrowingConsumer<Appendable> content) {
        Assert.notNull(content, "'content' must not be null");
        this.addFile(kind, path, new AppendableConsumerInputStreamSource(content));
    }

    public void addFile(Kind var1, String var2, InputStreamSource var3);

    private static String getClassNamePath(String className) {
        Assert.hasLength(className, "'className' must not be empty");
        GeneratedFiles.validatePackage(ClassUtils.getPackageName(className), className);
        Assert.isTrue(GeneratedFiles.isJavaIdentifier(className), "'className' must be a valid identifier, got '" + className + "'");
        return ClassUtils.convertClassNameToResourcePath(className) + ".java";
    }

    private static void validatePackage(String packageName, String className) {
        if (!StringUtils.hasLength(packageName)) {
            throw new IllegalArgumentException("Could not add '" + className + "', processing classes in the default package is not supported. Did you forget to add a package statement?");
        }
    }

    private static boolean isJavaIdentifier(String className) {
        char[] chars = className.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(chars[i])) {
                return false;
            }
            if (i <= 0 || chars[i] == '.' || Character.isJavaIdentifierPart(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static enum Kind {
        SOURCE,
        RESOURCE,
        CLASS;

    }
}

