/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.util.Args;
import org.gradle.internal.classpath.declarations.FileInputStreamInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class FileEntity
extends AbstractHttpEntity {
    private final File file;

    public FileEntity(File file, ContentType contentType, String contentEncoding) {
        super(contentType, contentEncoding);
        this.file = Args.notNull(file, "File");
    }

    public FileEntity(File file, ContentType contentType) {
        super(contentType, null);
        this.file = Args.notNull(file, "File");
    }

    @Override
    public final boolean isRepeatable() {
        return true;
    }

    @Override
    public final long getContentLength() {
        return FileInterceptorsDeclaration.intercept_length((File)this.file, (String)"org.apache.hc.core5.http.io.entity.FileEntity");
    }

    @Override
    public final InputStream getContent() throws IOException {
        File file = this.file;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)fileInputStream, (File)file, (String)"org.apache.hc.core5.http.io.entity.FileEntity");
        return fileInputStream;
    }

    @Override
    public final boolean isStreaming() {
        return false;
    }

    @Override
    public final void close() throws IOException {
    }
}

