/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.json;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class MappedObject {
    private final JsonNode node;
    private final MethodHandles.Lookup lookup;

    protected MappedObject(JsonNode node, MethodHandles.Lookup lookup) {
        this.node = node;
        this.lookup = lookup;
    }

    protected final JsonNode getNode() {
        return this.node;
    }

    protected <T> T valueAt(String expression, Class<T> type) {
        return MappedObject.valueAt(this, this.node, this.lookup, expression, type);
    }

    protected <T> List<T> childrenAt(String expression, Function<JsonNode, T> factory) {
        JsonNode node;
        JsonNode jsonNode = node = expression != null ? this.node.at(expression) : this.node;
        if (node.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList children = new ArrayList();
        node.elements().forEachRemaining((Consumer<JsonNode> & Serializable)childNode -> children.add(factory.apply((JsonNode)childNode)));
        return Collections.unmodifiableList(children);
    }

    protected static <T extends MappedObject> T getRoot(Object proxy) {
        MappedInvocationHandler handler = (MappedInvocationHandler)Proxy.getInvocationHandler(proxy);
        return (T)handler.root;
    }

    protected static <T> T valueAt(Object proxy, String expression, Class<T> type) {
        MappedInvocationHandler handler = (MappedInvocationHandler)Proxy.getInvocationHandler(proxy);
        return MappedObject.valueAt(handler.root, handler.node, handler.lookup, expression, type);
    }

    private static <T> T valueAt(MappedObject root, JsonNode node, MethodHandles.Lookup lookup, String expression, Class<T> type) {
        JsonNode result = node.at(expression);
        if (result.isMissingNode() && expression.startsWith("/") && expression.length() > 1 && Character.isLowerCase(expression.charAt(1))) {
            StringBuilder alternative = new StringBuilder(expression);
            alternative.setCharAt(1, Character.toUpperCase(alternative.charAt(1)));
            result = node.at(alternative.toString());
        }
        if (type.isInterface() && !type.getName().startsWith("java")) {
            return (T)Proxy.newProxyInstance(MappedObject.class.getClassLoader(), new Class[]{type}, (InvocationHandler)new MappedInvocationHandler(root, result, lookup));
        }
        if (result.isMissingNode()) {
            return null;
        }
        try {
            return (T)SharedObjectMapper.get().treeToValue((TreeNode)result, type);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected static <T extends MappedObject> T of(String content, Function<JsonNode, T> factory) throws IOException {
        return MappedObject.of(content, ObjectMapper::readTree, factory);
    }

    protected static <T extends MappedObject> T of(InputStream content, Function<JsonNode, T> factory) throws IOException {
        return MappedObject.of(StreamUtils.nonClosing((InputStream)content), ObjectMapper::readTree, factory);
    }

    protected static <T extends MappedObject, C> T of(C content, ContentReader<C> reader, Function<JsonNode, T> factory) throws IOException {
        ObjectMapper objectMapper = SharedObjectMapper.get();
        JsonNode node = reader.read(objectMapper, content);
        return (T)((MappedObject)factory.apply(node));
    }

    private static class MappedInvocationHandler
    implements InvocationHandler {
        private static final String GET = "get";
        private static final String IS = "is";
        private final MappedObject root;
        private final JsonNode node;
        private final MethodHandles.Lookup lookup;

        MappedInvocationHandler(MappedObject root, JsonNode node, MethodHandles.Lookup lookup) {
            this.root = root;
            this.node = node;
            this.lookup = lookup;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> declaringClass = method.getDeclaringClass();
            if (method.isDefault()) {
                MethodHandles.Lookup lookup = this.lookup.in(declaringClass);
                MethodHandle methodHandle = lookup.unreflectSpecial(method, declaringClass).bindTo(proxy);
                return methodHandle.invokeWithArguments(new Object[0]);
            }
            if (declaringClass == Object.class) {
                method.invoke(proxy, args);
            }
            Assert.state((args == null || args.length == 0 ? 1 : 0) != 0, (Supplier<String> & Serializable)() -> "Unsupported method " + method);
            String name = this.getName(method.getName());
            Class<?> type = method.getReturnType();
            return this.valueForProperty(name, type);
        }

        private String getName(String name) {
            StringBuilder result = new StringBuilder(name);
            if (name.startsWith(GET)) {
                result = new StringBuilder(name.substring(GET.length()));
            }
            if (name.startsWith(IS)) {
                result = new StringBuilder(name.substring(IS.length()));
            }
            Assert.state((result.length() >= 0 ? 1 : 0) != 0, (String)"Missing name");
            result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
            return result.toString();
        }

        private Object valueForProperty(String name, Class<?> type) {
            return MappedObject.valueAt(this.root, this.node, this.lookup, "/" + name, type);
        }
    }

    @FunctionalInterface
    protected static interface ContentReader<C> {
        public JsonNode read(ObjectMapper var1, C var2) throws IOException;
    }
}

