/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.boot.buildpack.platform.docker.type.BlobReference;
import org.springframework.boot.buildpack.platform.json.MappedObject;

public class ManifestList
extends MappedObject {
    private final Integer schemaVersion = this.valueAt("/schemaVersion", Integer.class);
    private final String mediaType = this.valueAt("/mediaType", String.class);
    private final List<BlobReference> manifests = this.childrenAt("/manifests", BlobReference::new);

    protected ManifestList(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    public Integer getSchemaVersion() {
        return this.schemaVersion;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public Stream<BlobReference> streamManifests() {
        return this.getManifests().stream();
    }

    public List<BlobReference> getManifests() {
        return this.manifests;
    }

    public static ManifestList of(InputStream content) throws IOException {
        return (ManifestList)ManifestList.of(content, ManifestList::new);
    }
}

