/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.buildpack.platform.docker.type.ImageName;
import org.springframework.boot.buildpack.platform.docker.type.RandomString;
import org.springframework.boot.buildpack.platform.docker.type.Regex;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class ImageReference {
    private static final Pattern JAR_VERSION_PATTERN = Pattern.compile("^(.*)(-\\d+)$");
    private static final String LATEST = "latest";
    private final ImageName name;
    private final String tag;
    private final String digest;
    private final String string;

    private ImageReference(ImageName name, String tag, String digest) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.name = name;
        this.tag = tag;
        this.digest = digest;
        this.string = this.buildString(name.toString(), tag, digest);
    }

    public String getDomain() {
        return this.name.getDomain();
    }

    public String getName() {
        return this.name.getName();
    }

    public String getTag() {
        return this.tag;
    }

    public String getDigest() {
        return this.digest;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImageReference other = (ImageReference)obj;
        boolean result = true;
        result = result && this.name.equals(other.name);
        result = result && ObjectUtils.nullSafeEquals((Object)this.tag, (Object)other.tag);
        result = result && ObjectUtils.nullSafeEquals((Object)this.digest, (Object)other.digest);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.tag);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.digest);
        return result;
    }

    public String toString() {
        return this.string;
    }

    public String toLegacyString() {
        return this.buildString(this.name.toLegacyString(), this.tag, this.digest);
    }

    private String buildString(String name, String tag, String digest) {
        StringBuilder string = new StringBuilder(name);
        if (tag != null) {
            string.append(":").append(tag);
        }
        if (digest != null) {
            string.append("@").append(digest);
        }
        return string.toString();
    }

    public ImageReference withDigest(String digest) {
        return new ImageReference(this.name, null, digest);
    }

    public ImageReference inTaggedForm() {
        Assert.state((this.digest == null ? 1 : 0) != 0, (Supplier<String> & Serializable)() -> "Image reference '" + this + "' cannot contain a digest");
        return new ImageReference(this.name, this.tag != null ? this.tag : LATEST, null);
    }

    public ImageReference inTaglessForm() {
        if (this.tag == null) {
            return this;
        }
        return new ImageReference(this.name, null, this.digest);
    }

    public ImageReference inTaggedOrDigestForm() {
        if (this.digest != null) {
            return this;
        }
        return this.inTaggedForm();
    }

    public static ImageReference forJarFile(File jarFile) {
        String filename = jarFile.getName();
        Assert.isTrue((boolean)filename.toLowerCase().endsWith(".jar"), (Supplier<String> & Serializable)() -> "File '" + jarFile + "' is not a JAR");
        filename = filename.substring(0, filename.length() - 4);
        int firstDot = filename.indexOf(46);
        if (firstDot == -1) {
            return ImageReference.of(filename);
        }
        String name = filename.substring(0, firstDot);
        Object version = filename.substring(firstDot + 1);
        Matcher matcher = JAR_VERSION_PATTERN.matcher(name);
        if (matcher.matches()) {
            name = matcher.group(1);
            version = matcher.group(2).substring(1) + "." + (String)version;
        }
        return ImageReference.of(ImageName.of(name), (String)version);
    }

    public static ImageReference random(String prefix) {
        return ImageReference.random(prefix, 10);
    }

    public static ImageReference random(String prefix, int randomLength) {
        return ImageReference.of(RandomString.generate(prefix, randomLength));
    }

    public static ImageReference of(String value) {
        String remainder;
        Matcher matcher;
        String remainder2;
        Matcher matcher2;
        Assert.hasText((String)value, (String)"Value must not be null");
        String domain = ImageName.parseDomain(value);
        Object path = domain != null ? value.substring(domain.length() + 1) : value;
        String digest = null;
        int digestSplit = ((String)path).indexOf("@");
        if (digestSplit != -1 && (matcher2 = Regex.DIGEST.matcher(remainder2 = ((String)path).substring(digestSplit + 1))).find()) {
            digest = remainder2.substring(0, matcher2.end());
            remainder2 = remainder2.substring(matcher2.end());
            path = ((String)path).substring(0, digestSplit) + remainder2;
        }
        String tag = null;
        int tagSplit = ((String)path).lastIndexOf(":");
        if (tagSplit != -1 && (matcher = Regex.TAG.matcher(remainder = ((String)path).substring(tagSplit + 1))).find()) {
            tag = remainder.substring(0, matcher.end());
            remainder = remainder.substring(matcher.end());
            path = ((String)path).substring(0, tagSplit) + remainder;
        }
        Assert.isTrue((ImageReference.isLowerCase((String)path) && ImageReference.matchesPathRegex((String)path) ? 1 : 0) != 0, (Supplier<String> & Serializable)() -> "Unable to parse image reference \"" + value + "\". Image reference must be in the form '[domainHost:port/][path/]name[:tag][@digest]', with 'path' and 'name' containing only [a-z0-9][.][_][-]");
        ImageName name = new ImageName(domain, (String)path);
        return new ImageReference(name, tag, digest);
    }

    private static boolean isLowerCase(String path) {
        return path.toLowerCase(Locale.ENGLISH).equals(path);
    }

    private static boolean matchesPathRegex(String path) {
        return Regex.PATH.matcher(path).matches();
    }

    public static ImageReference of(ImageName name) {
        return new ImageReference(name, null, null);
    }

    public static ImageReference of(ImageName name, String tag) {
        return new ImageReference(name, tag, null);
    }

    public static ImageReference of(ImageName name, String tag, String digest) {
        return new ImageReference(name, tag, digest);
    }
}

