/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;
import org.springframework.boot.buildpack.platform.docker.type.BlobReference;
import org.springframework.boot.buildpack.platform.docker.type.ImageArchiveIndex;
import org.springframework.boot.buildpack.platform.docker.type.ImageArchiveManifest;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.Manifest;
import org.springframework.boot.buildpack.platform.docker.type.ManifestList;
import org.springframework.boot.buildpack.platform.io.IOBiConsumer;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.Assert;
import org.springframework.util.function.ThrowingFunction;

class ExportedImageTar
implements Closeable {
    private final Path tarFile = Files.createTempFile("docker-layers-", null, new FileAttribute[0]);
    private final LayerArchiveFactory layerArchiveFactory;

    ExportedImageTar(ImageReference reference, InputStream inputStream) throws IOException {
        Files.copy(inputStream, this.tarFile, StandardCopyOption.REPLACE_EXISTING);
        this.layerArchiveFactory = LayerArchiveFactory.create(reference, this.tarFile);
    }

    void exportLayers(IOBiConsumer<String, TarArchive> exports) throws IOException {
        try (TarArchiveInputStream tar = ExportedImageTar.openTar(this.tarFile);){
            TarArchiveEntry entry = tar.getNextEntry();
            while (entry != null) {
                TarArchive layerArchive = this.layerArchiveFactory.getLayerArchive(tar, entry);
                if (layerArchive != null) {
                    exports.accept(entry.getName(), layerArchive);
                }
                entry = tar.getNextEntry();
            }
        }
    }

    private static TarArchiveInputStream openTar(Path path) throws IOException {
        return new TarArchiveInputStream(NioFileInterceptors.intercept_newInputStream((Path)path, (OpenOption[])new OpenOption[0], (String)"org.springframework.boot.buildpack.platform.docker.ExportedImageTar"));
    }

    @Override
    public void close() throws IOException {
        Files.delete(this.tarFile);
    }

    private static abstract class LayerArchiveFactory {
        private LayerArchiveFactory() {
        }

        abstract TarArchive getLayerArchive(TarArchiveInputStream var1, TarArchiveEntry var2);

        static LayerArchiveFactory create(ImageReference reference, Path tarFile) throws IOException {
            try (TarArchiveInputStream tar = ExportedImageTar.openTar(tarFile);){
                ImageArchiveIndex index = null;
                ImageArchiveManifest manifest = null;
                TarArchiveEntry entry = tar.getNextEntry();
                while (entry != null) {
                    if ("index.json".equals(entry.getName())) {
                        index = ImageArchiveIndex.of((InputStream)tar);
                        break;
                    }
                    if ("manifest.json".equals(entry.getName())) {
                        manifest = ImageArchiveManifest.of((InputStream)tar);
                    }
                    entry = tar.getNextEntry();
                }
                Assert.state((index != null || manifest != null ? 1 : 0) != 0, (String)"Exported image '%s' does not contain 'index.json' or 'manifest.json'".formatted(reference));
                LayerArchiveFactory layerArchiveFactory = index != null ? new IndexLayerArchiveFactory(tarFile, index) : new ManifestLayerArchiveFactory(tarFile, manifest);
                return layerArchiveFactory;
            }
        }
    }

    private static class ManifestLayerArchiveFactory
    extends LayerArchiveFactory {
        private Set<String> layers;

        ManifestLayerArchiveFactory(Path tarFile, ImageArchiveManifest manifest) {
            this.layers = manifest.getEntries().stream().flatMap((Function<ImageArchiveManifest.ManifestEntry, Stream> & Serializable)entry -> entry.getLayers().stream()).collect(Collectors.toUnmodifiableSet());
        }

        @Override
        TarArchive getLayerArchive(TarArchiveInputStream tar, TarArchiveEntry entry) {
            if (!this.layers.contains(entry.getName())) {
                return null;
            }
            return TarArchive.fromInputStream((InputStream)tar, TarArchive.Compression.NONE);
        }
    }

    private static class IndexLayerArchiveFactory
    extends LayerArchiveFactory {
        private final Map<String, String> layerMediaTypes;

        IndexLayerArchiveFactory(Path tarFile, ImageArchiveIndex index) throws IOException {
            Set<String> manifestDigests = this.getDigests(index, this::isManifest);
            List<ManifestList> manifestLists = this.getManifestLists(tarFile, this.getDigests(index, this::isManifestList));
            List<Manifest> manifests = this.getManifests(tarFile, manifestDigests, manifestLists);
            this.layerMediaTypes = manifests.stream().flatMap((Function<Manifest, Stream> & Serializable)manifest -> manifest.getLayers().stream()).collect(Collectors.toMap(this::getEntryName, BlobReference::getMediaType));
        }

        private Set<String> getDigests(ImageArchiveIndex index, Predicate<BlobReference> predicate) {
            return index.getManifests().stream().filter(predicate).map(BlobReference::getDigest).collect(Collectors.toUnmodifiableSet());
        }

        private List<ManifestList> getManifestLists(Path tarFile, Set<String> digests) throws IOException {
            return this.getDigestMatches(tarFile, digests, ManifestList::of);
        }

        private List<Manifest> getManifests(Path tarFile, Set<String> manifestDigests, List<ManifestList> manifestLists) throws IOException {
            HashSet<String> digests = new HashSet<String>(manifestDigests);
            manifestLists.stream().flatMap(ManifestList::streamManifests).filter(this::isManifest).map(BlobReference::getDigest).forEach(digests::add);
            return this.getDigestMatches(tarFile, digests, Manifest::of);
        }

        private <T> List<T> getDigestMatches(Path tarFile, Set<String> digests, ThrowingFunction<InputStream, T> factory) throws IOException {
            if (digests.isEmpty()) {
                return Collections.emptyList();
            }
            Set names = digests.stream().map(this::getEntryName).collect(Collectors.toUnmodifiableSet());
            ArrayList<Object> result = new ArrayList<Object>();
            try (TarArchiveInputStream tar = ExportedImageTar.openTar(tarFile);){
                TarArchiveEntry entry = tar.getNextEntry();
                while (entry != null) {
                    if (names.contains(entry.getName())) {
                        result.add(factory.apply((Object)tar));
                    }
                    entry = tar.getNextEntry();
                }
            }
            return Collections.unmodifiableList(result);
        }

        private boolean isManifest(BlobReference reference) {
            return this.isJsonWithPrefix(reference.getMediaType(), "application/vnd.oci.image.manifest.v") || this.isJsonWithPrefix(reference.getMediaType(), "application/vnd.docker.distribution.manifest.v");
        }

        private boolean isManifestList(BlobReference reference) {
            return this.isJsonWithPrefix(reference.getMediaType(), "application/vnd.docker.distribution.manifest.list.v");
        }

        private boolean isJsonWithPrefix(String mediaType, String prefix) {
            return mediaType.startsWith(prefix) && mediaType.endsWith("+json");
        }

        private String getEntryName(BlobReference reference) {
            return this.getEntryName(reference.getDigest());
        }

        private String getEntryName(String digest) {
            return "blobs/" + digest.replace(':', '/');
        }

        @Override
        TarArchive getLayerArchive(TarArchiveInputStream tar, TarArchiveEntry entry) {
            String mediaType = this.layerMediaTypes.get(entry.getName());
            if (mediaType == null) {
                return null;
            }
            return TarArchive.fromInputStream((InputStream)tar, this.getCompression(mediaType));
        }

        private TarArchive.Compression getCompression(String mediaType) {
            if (mediaType.endsWith(".tar.gzip")) {
                return TarArchive.Compression.GZIP;
            }
            if (mediaType.endsWith(".tar.zstd")) {
                return TarArchive.Compression.ZSTD;
            }
            return TarArchive.Compression.NONE;
        }
    }
}

