/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.hc.core5.net.URIBuilder;
import org.springframework.boot.buildpack.platform.docker.ExportedImageTar;
import org.springframework.boot.buildpack.platform.docker.LoadImageUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.LogUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.ProgressUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.PullImageUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.PushImageUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.UpdateListener;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfiguration;
import org.springframework.boot.buildpack.platform.docker.transport.HttpTransport;
import org.springframework.boot.buildpack.platform.docker.type.ContainerConfig;
import org.springframework.boot.buildpack.platform.docker.type.ContainerContent;
import org.springframework.boot.buildpack.platform.docker.type.ContainerReference;
import org.springframework.boot.buildpack.platform.docker.type.ContainerStatus;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageArchive;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.VolumeName;
import org.springframework.boot.buildpack.platform.io.IOBiConsumer;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.boot.buildpack.platform.json.JsonStream;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DockerApi {
    private static final List<String> FORCE_PARAMS = Collections.unmodifiableList(Arrays.asList("force", "1"));
    static final String API_VERSION = "v1.24";
    private final HttpTransport http;
    private final JsonStream jsonStream;
    private final ImageApi image;
    private final ContainerApi container;
    private final VolumeApi volume;

    public DockerApi() {
        this(HttpTransport.create(null));
    }

    public DockerApi(DockerConfiguration.DockerHostConfiguration dockerHost) {
        this(HttpTransport.create(dockerHost));
    }

    DockerApi(HttpTransport http) {
        this.http = http;
        this.jsonStream = new JsonStream(SharedObjectMapper.get());
        this.image = new ImageApi();
        this.container = new ContainerApi();
        this.volume = new VolumeApi();
    }

    private HttpTransport http() {
        return this.http;
    }

    private JsonStream jsonStream() {
        return this.jsonStream;
    }

    private URI buildUrl(String path, Collection<?> params) {
        return this.buildUrl(path, params != null ? params.toArray() : null);
    }

    private URI buildUrl(String path, Object ... params) {
        try {
            URIBuilder builder = new URIBuilder("/v1.24" + path);
            int param = 0;
            while (param < params.length) {
                builder.addParameter(Objects.toString(params[param++]), Objects.toString(params[param++]));
            }
            return builder.build();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public ImageApi image() {
        return this.image;
    }

    public ContainerApi container() {
        return this.container;
    }

    public VolumeApi volume() {
        return this.volume;
    }

    public class ImageApi {
        ImageApi() {
        }

        public Image pull(ImageReference reference, UpdateListener<PullImageUpdateEvent> listener) throws IOException {
            return this.pull(reference, listener, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Image pull(ImageReference reference, UpdateListener<PullImageUpdateEvent> listener, String registryAuth) throws IOException {
            Assert.notNull((Object)reference, (String)"Reference must not be null");
            Assert.notNull(listener, (String)"Listener must not be null");
            URI createUri = DockerApi.this.buildUrl("/images/create", "fromImage", reference);
            DigestCaptureUpdateListener digestCapture = new DigestCaptureUpdateListener();
            listener.onStart();
            try {
                try (HttpTransport.Response response = DockerApi.this.http().post(createUri, registryAuth);){
                    DockerApi.this.jsonStream().get(response.getContent(), PullImageUpdateEvent.class, (Consumer<PullImageUpdateEvent> & Serializable)event -> {
                        digestCapture.onUpdate((ProgressUpdateEvent)event);
                        listener.onUpdate((PullImageUpdateEvent)event);
                    });
                }
                Image image = this.inspect(reference);
                return image;
            }
            finally {
                listener.onFinish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(ImageReference reference, UpdateListener<PushImageUpdateEvent> listener, String registryAuth) throws IOException {
            Assert.notNull((Object)reference, (String)"Reference must not be null");
            Assert.notNull(listener, (String)"Listener must not be null");
            URI pushUri = DockerApi.this.buildUrl("/images/" + reference + "/push", new Object[0]);
            ErrorCaptureUpdateListener errorListener = new ErrorCaptureUpdateListener();
            listener.onStart();
            try (HttpTransport.Response response = DockerApi.this.http().post(pushUri, registryAuth);){
                DockerApi.this.jsonStream().get(response.getContent(), PushImageUpdateEvent.class, (Consumer<PushImageUpdateEvent> & Serializable)event -> {
                    errorListener.onUpdate((PushImageUpdateEvent)event);
                    listener.onUpdate((PushImageUpdateEvent)event);
                });
            }
            finally {
                listener.onFinish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(ImageArchive archive, UpdateListener<LoadImageUpdateEvent> listener) throws IOException {
            Assert.notNull((Object)archive, (String)"Archive must not be null");
            Assert.notNull(listener, (String)"Listener must not be null");
            URI loadUri = DockerApi.this.buildUrl("/images/load", new Object[0]);
            StreamCaptureUpdateListener streamListener = new StreamCaptureUpdateListener();
            listener.onStart();
            try {
                try (HttpTransport.Response response = DockerApi.this.http().post(loadUri, "application/x-tar", archive::writeTo);){
                    DockerApi.this.jsonStream().get(response.getContent(), LoadImageUpdateEvent.class, (Consumer<LoadImageUpdateEvent> & Serializable)event -> {
                        streamListener.onUpdate((LoadImageUpdateEvent)event);
                        listener.onUpdate((LoadImageUpdateEvent)event);
                    });
                }
                Assert.state((boolean)StringUtils.hasText((String)streamListener.getCapturedStream()), (String)("Invalid response received when loading image " + (String)(archive.getTag() != null ? "\"" + archive.getTag() + "\"" : "")));
            }
            finally {
                listener.onFinish();
            }
        }

        @Deprecated(since="3.2.6", forRemoval=true)
        public void exportLayerFiles(ImageReference reference, IOBiConsumer<String, Path> exports) throws IOException {
            Assert.notNull((Object)reference, (String)"Reference must not be null");
            Assert.notNull(exports, (String)"Exports must not be null");
            this.exportLayers(reference, (IOBiConsumer<String, TarArchive> & Serializable)(name, archive) -> {
                Path path = Files.createTempFile("docker-export-layer-files-", null, new FileAttribute[0]);
                try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                    archive.writeTo(out);
                    exports.accept((String)name, path);
                }
                finally {
                    Files.delete(path);
                }
            });
        }

        public void exportLayers(ImageReference reference, IOBiConsumer<String, TarArchive> exports) throws IOException {
            Assert.notNull((Object)reference, (String)"Reference must not be null");
            Assert.notNull(exports, (String)"Exports must not be null");
            URI uri = DockerApi.this.buildUrl("/images/" + reference + "/get", new Object[0]);
            try (HttpTransport.Response response = DockerApi.this.http().get(uri);
                 ExportedImageTar exportedImageTar = new ExportedImageTar(reference, response.getContent());){
                exportedImageTar.exportLayers(exports);
            }
        }

        public void remove(ImageReference reference, boolean force) throws IOException {
            Assert.notNull((Object)reference, (String)"Reference must not be null");
            Collection<String> params = force ? FORCE_PARAMS : Collections.emptySet();
            URI uri = DockerApi.this.buildUrl("/images/" + reference, params);
            DockerApi.this.http().delete(uri).close();
        }

        public Image inspect(ImageReference reference) throws IOException {
            Assert.notNull((Object)reference, (String)"Reference must not be null");
            URI imageUri = DockerApi.this.buildUrl("/images/" + reference + "/json", new Object[0]);
            try (HttpTransport.Response response = DockerApi.this.http().get(imageUri);){
                Image image = Image.of(response.getContent());
                return image;
            }
        }

        public void tag(ImageReference sourceReference, ImageReference targetReference) throws IOException {
            Assert.notNull((Object)sourceReference, (String)"SourceReference must not be null");
            Assert.notNull((Object)targetReference, (String)"TargetReference must not be null");
            String tag = targetReference.getTag();
            String path = "/images/" + sourceReference + "/tag";
            URI uri = tag != null ? DockerApi.this.buildUrl(path, "repo", targetReference.inTaglessForm(), "tag", tag) : DockerApi.this.buildUrl(path, "repo", targetReference);
            DockerApi.this.http().post(uri).close();
        }
    }

    public class ContainerApi {
        ContainerApi() {
        }

        public ContainerReference create(ContainerConfig config, ContainerContent ... contents) throws IOException {
            Assert.notNull((Object)config, (String)"Config must not be null");
            Assert.noNullElements((Object[])contents, (String)"Contents must not contain null elements");
            ContainerReference containerReference = this.createContainer(config);
            for (ContainerContent content : contents) {
                this.uploadContainerContent(containerReference, content);
            }
            return containerReference;
        }

        private ContainerReference createContainer(ContainerConfig config) throws IOException {
            URI createUri = DockerApi.this.buildUrl("/containers/create", new Object[0]);
            try (HttpTransport.Response response = DockerApi.this.http().post(createUri, "application/json", config::writeTo);){
                ContainerReference containerReference = ContainerReference.of(SharedObjectMapper.get().readTree(response.getContent()).at("/Id").asText());
                return containerReference;
            }
        }

        private void uploadContainerContent(ContainerReference reference, ContainerContent content) throws IOException {
            URI uri = DockerApi.this.buildUrl("/containers/" + reference + "/archive", "path", content.getDestinationPath());
            DockerApi.this.http().put(uri, "application/x-tar", content.getArchive()::writeTo).close();
        }

        public void start(ContainerReference reference) throws IOException {
            Assert.notNull((Object)reference, (String)"Reference must not be null");
            URI uri = DockerApi.this.buildUrl("/containers/" + reference + "/start", new Object[0]);
            DockerApi.this.http().post(uri).close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logs(ContainerReference reference, UpdateListener<LogUpdateEvent> listener) throws IOException {
            Assert.notNull((Object)reference, (String)"Reference must not be null");
            Assert.notNull(listener, (String)"Listener must not be null");
            Object[] params = new Object[]{"stdout", "1", "stderr", "1", "follow", "1"};
            URI uri = DockerApi.this.buildUrl("/containers/" + reference + "/logs", params);
            listener.onStart();
            try (HttpTransport.Response response = DockerApi.this.http().get(uri);){
                LogUpdateEvent.readAll(response.getContent(), listener::onUpdate);
            }
            finally {
                listener.onFinish();
            }
        }

        public ContainerStatus wait(ContainerReference reference) throws IOException {
            Assert.notNull((Object)reference, (String)"Reference must not be null");
            URI uri = DockerApi.this.buildUrl("/containers/" + reference + "/wait", new Object[0]);
            try (HttpTransport.Response response = DockerApi.this.http().post(uri);){
                ContainerStatus containerStatus = ContainerStatus.of(response.getContent());
                return containerStatus;
            }
        }

        public void remove(ContainerReference reference, boolean force) throws IOException {
            Assert.notNull((Object)reference, (String)"Reference must not be null");
            Collection<String> params = force ? FORCE_PARAMS : Collections.emptySet();
            URI uri = DockerApi.this.buildUrl("/containers/" + reference, params);
            DockerApi.this.http().delete(uri).close();
        }
    }

    public class VolumeApi {
        VolumeApi() {
        }

        public void delete(VolumeName name, boolean force) throws IOException {
            Assert.notNull((Object)name, (String)"Name must not be null");
            Collection<String> params = force ? FORCE_PARAMS : Collections.emptySet();
            URI uri = DockerApi.this.buildUrl("/volumes/" + name, params);
            DockerApi.this.http().delete(uri).close();
        }
    }

    private static final class ErrorCaptureUpdateListener
    implements UpdateListener<PushImageUpdateEvent> {
        private ErrorCaptureUpdateListener() {
        }

        @Override
        public void onUpdate(PushImageUpdateEvent event) {
            Assert.state((event.getErrorDetail() == null ? 1 : 0) != 0, (Supplier<String> & Serializable)() -> "Error response received when pushing image: " + event.getErrorDetail().getMessage());
        }
    }

    private static final class StreamCaptureUpdateListener
    implements UpdateListener<LoadImageUpdateEvent> {
        private String stream;

        private StreamCaptureUpdateListener() {
        }

        @Override
        public void onUpdate(LoadImageUpdateEvent event) {
            this.stream = event.getStream();
        }

        String getCapturedStream() {
            return this.stream;
        }
    }

    private static final class DigestCaptureUpdateListener
    implements UpdateListener<ProgressUpdateEvent> {
        private static final String PREFIX = "Digest:";
        private String digest;

        private DigestCaptureUpdateListener() {
        }

        @Override
        public void onUpdate(ProgressUpdateEvent event) {
            String status = event.getStatus();
            if (status != null && status.startsWith(PREFIX)) {
                String digest = status.substring(PREFIX.length()).trim();
                Assert.state((this.digest == null || this.digest.equals(digest) ? 1 : 0) != 0, (String)"Different digests IDs provided");
                this.digest = digest;
            }
        }
    }
}

